/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.compare;

import java.util.List;
import java.util.Objects;
import shadow.palantir.driver.org.apache.arrow.vector.BaseFixedWidthVector;
import shadow.palantir.driver.org.apache.arrow.vector.BaseLargeVariableWidthVector;
import shadow.palantir.driver.org.apache.arrow.vector.BaseVariableWidthVector;
import shadow.palantir.driver.org.apache.arrow.vector.BaseVariableWidthViewVector;
import shadow.palantir.driver.org.apache.arrow.vector.ExtensionTypeVector;
import shadow.palantir.driver.org.apache.arrow.vector.NullVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.compare.VectorVisitor;
import shadow.palantir.driver.org.apache.arrow.vector.complex.DenseUnionVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.FixedSizeListVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.LargeListVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.LargeListViewVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.ListVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.ListViewVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.NonNullableStructVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.RunEndEncodedVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.UnionVector;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Field;

public class TypeEqualsVisitor
implements VectorVisitor<Boolean, Void> {
    private final ValueVector right;
    private final boolean checkName;
    private final boolean checkMetadata;

    public TypeEqualsVisitor(ValueVector right) {
        this(right, true, true);
    }

    public TypeEqualsVisitor(ValueVector right, boolean checkName, boolean checkMetadata) {
        this.right = right;
        this.checkName = checkName;
        this.checkMetadata = checkMetadata;
    }

    public boolean equals(ValueVector left) {
        return left.accept(this, null);
    }

    @Override
    public Boolean visit(BaseFixedWidthVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(BaseVariableWidthVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(BaseLargeVariableWidthVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(BaseVariableWidthViewVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(ListVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(FixedSizeListVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(LargeListVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(NonNullableStructVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(UnionVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(DenseUnionVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(NullVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(ExtensionTypeVector<?> left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(ListViewVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(LargeListViewVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    @Override
    public Boolean visit(RunEndEncodedVector left, Void value) {
        return this.compareField(left.getField(), this.right.getField());
    }

    private boolean compareField(Field leftField, Field rightField) {
        if (leftField == rightField) {
            return true;
        }
        return !(this.checkName && !Objects.equals(leftField.getName(), rightField.getName()) || !Objects.equals(leftField.isNullable(), rightField.isNullable()) || !Objects.equals(leftField.getType(), rightField.getType()) || !Objects.equals(leftField.getDictionary(), rightField.getDictionary()) || this.checkMetadata && !Objects.equals(leftField.getMetadata(), rightField.getMetadata()) || !this.compareChildren(leftField.getChildren(), rightField.getChildren()));
    }

    private boolean compareChildren(List<Field> leftChildren, List<Field> rightChildren) {
        if (leftChildren.size() != rightChildren.size()) {
            return false;
        }
        for (int i = 0; i < leftChildren.size(); ++i) {
            if (this.compareField(leftChildren.get(i), rightChildren.get(i))) continue;
            return false;
        }
        return true;
    }
}

