/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.complex.impl;

import java.nio.ByteBuffer;
import shadow.palantir.driver.org.apache.arrow.memory.ArrowBuf;
import shadow.palantir.driver.org.apache.arrow.vector.LargeVarBinaryVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import shadow.palantir.driver.org.apache.arrow.vector.holders.LargeVarBinaryHolder;
import shadow.palantir.driver.org.apache.arrow.vector.holders.NullableLargeVarBinaryHolder;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Field;

public class LargeVarBinaryWriterImpl
extends AbstractFieldWriter {
    final LargeVarBinaryVector vector;

    public LargeVarBinaryWriterImpl(LargeVarBinaryVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(LargeVarBinaryHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableLargeVarBinaryHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarBinary(long start, long end, ArrowBuf buffer) {
        this.vector.setSafe(this.idx(), 1, start, end, buffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarBinary(byte[] value) {
        this.vector.setSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarBinary(byte[] value, int offset, int length) {
        this.vector.setSafe(this.idx(), value, offset, length);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarBinary(ByteBuffer value) {
        this.vector.setSafe(this.idx(), value, 0, value.remaining());
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarBinary(ByteBuffer value, int offset, int length) {
        this.vector.setSafe(this.idx(), value, offset, length);
        this.vector.setValueCount(this.idx() + 1);
    }
}

