/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.complex.impl;

import shadow.palantir.driver.org.apache.arrow.memory.ArrowBuf;
import shadow.palantir.driver.org.apache.arrow.vector.LargeVarCharVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import shadow.palantir.driver.org.apache.arrow.vector.holders.LargeVarCharHolder;
import shadow.palantir.driver.org.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Field;
import shadow.palantir.driver.org.apache.arrow.vector.util.Text;

public class LargeVarCharWriterImpl
extends AbstractFieldWriter {
    final LargeVarCharVector vector;
    private final Text textBuffer = new Text();

    public LargeVarCharWriterImpl(LargeVarCharVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(LargeVarCharHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableLargeVarCharHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarChar(long start, long end, ArrowBuf buffer) {
        this.vector.setSafe(this.idx(), 1, start, end, buffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarChar(Text value) {
        this.vector.setSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarChar(String value) {
        this.textBuffer.set(value);
        this.vector.setSafe(this.idx(), this.textBuffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

