/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.complex.impl;

import shadow.palantir.driver.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import shadow.palantir.driver.org.apache.arrow.vector.holders.BitHolder;
import shadow.palantir.driver.org.apache.arrow.vector.holders.NullableBitHolder;
import shadow.palantir.driver.org.apache.arrow.vector.types.Types;

public class NullableBitHolderReaderImpl
extends AbstractFieldReader {
    private NullableBitHolder holder;

    public NullableBitHolderReaderImpl(NullableBitHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.BIT;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(BitHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableBitHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Boolean readBoolean() {
        if (!this.isSet()) {
            return null;
        }
        return new Boolean(this.holder.value != 0);
    }

    @Override
    public Object readObject() {
        return this.readBoolean();
    }
}

