/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.complex.impl;

import java.time.Duration;
import shadow.palantir.driver.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import shadow.palantir.driver.org.apache.arrow.vector.holders.IntervalDayHolder;
import shadow.palantir.driver.org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import shadow.palantir.driver.org.apache.arrow.vector.types.Types;

public class NullableIntervalDayHolderReaderImpl
extends AbstractFieldReader {
    private NullableIntervalDayHolder holder;

    public NullableIntervalDayHolderReaderImpl(NullableIntervalDayHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALDAY;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(IntervalDayHolder h) {
        h.days = this.holder.days;
        h.milliseconds = this.holder.milliseconds;
    }

    @Override
    public void read(NullableIntervalDayHolder h) {
        h.days = this.holder.days;
        h.milliseconds = this.holder.milliseconds;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Duration readDuration() {
        if (!this.isSet()) {
            return null;
        }
        return Duration.ofDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public Object readObject() {
        return this.readDuration();
    }
}

