/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.complex.impl;

import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import shadow.palantir.driver.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import shadow.palantir.driver.org.apache.arrow.vector.complex.writer.TimeStampSecWriter;
import shadow.palantir.driver.org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import shadow.palantir.driver.org.apache.arrow.vector.holders.TimeStampSecHolder;
import shadow.palantir.driver.org.apache.arrow.vector.types.Types;
import shadow.palantir.driver.org.apache.arrow.vector.util.DateUtility;

public class TimeStampSecHolderReaderImpl
extends AbstractFieldReader {
    private TimeStampSecHolder holder;

    public TimeStampSecHolderReaderImpl(TimeStampSecHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPSEC;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(TimeStampSecHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeStampSecHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        long millis = TimeUnit.SECONDS.toMillis(this.holder.value);
        return DateUtility.getLocalDateTimeFromEpochMilli(millis);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }

    @Override
    public void copyAsValue(TimeStampSecWriter writer) {
        writer.write(this.holder);
    }
}

