/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.complex.impl;

import shadow.palantir.driver.org.apache.arrow.vector.UInt2Vector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import shadow.palantir.driver.org.apache.arrow.vector.holders.NullableUInt2Holder;
import shadow.palantir.driver.org.apache.arrow.vector.holders.UInt2Holder;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Field;

public class UInt2WriterImpl
extends AbstractFieldWriter {
    final UInt2Vector vector;

    public UInt2WriterImpl(UInt2Vector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(UInt2Holder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableUInt2Holder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeUInt2(char value) {
        this.vector.setSafe(this.idx(), 1, value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

