/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.ipc.message;

import java.io.IOException;
import shadow.palantir.driver.org.apache.arrow.flatbuf.Message;
import shadow.palantir.driver.org.apache.arrow.memory.ArrowBuf;
import shadow.palantir.driver.org.apache.arrow.memory.BufferAllocator;
import shadow.palantir.driver.org.apache.arrow.vector.ipc.ReadChannel;
import shadow.palantir.driver.org.apache.arrow.vector.ipc.message.MessageMetadataResult;
import shadow.palantir.driver.org.apache.arrow.vector.ipc.message.MessageResult;
import shadow.palantir.driver.org.apache.arrow.vector.ipc.message.MessageSerializer;

public class MessageChannelReader
implements AutoCloseable {
    protected ReadChannel in;
    protected BufferAllocator allocator;

    public MessageChannelReader(ReadChannel in, BufferAllocator allocator) {
        this.in = in;
        this.allocator = allocator;
    }

    public MessageResult readNext() throws IOException {
        MessageMetadataResult result = MessageSerializer.readMessage(this.in);
        if (result == null) {
            return null;
        }
        Message message = result.getMessage();
        ArrowBuf bodyBuffer = null;
        if (result.messageHasBody()) {
            long bodyLength = result.getMessageBodyLength();
            bodyBuffer = MessageSerializer.readMessageBody(this.in, bodyLength, this.allocator);
        }
        return new MessageResult(message, bodyBuffer);
    }

    public long bytesRead() {
        return this.in.bytesRead();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

