/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class ByteArrayReadableSeekableByteChannel
implements SeekableByteChannel {
    private byte[] byteArray;
    private int position = 0;

    public ByteArrayReadableSeekableByteChannel(byte[] byteArray) {
        if (byteArray == null) {
            throw new NullPointerException();
        }
        this.byteArray = byteArray;
    }

    @Override
    public boolean isOpen() {
        return this.byteArray != null;
    }

    @Override
    public void close() throws IOException {
        this.byteArray = null;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int remainingInBuf = this.byteArray.length - this.position;
        int length = Math.min(dst.remaining(), remainingInBuf);
        dst.put(this.byteArray, this.position, length);
        this.position += length;
        return length;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.position = (int)newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.byteArray.length;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new UnsupportedOperationException("Read only");
    }
}

