/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.util;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.text.StringCharacterIterator;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonGenerationException;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonGenerator;
import shadow.palantir.driver.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import shadow.palantir.driver.org.apache.arrow.vector.util.ReusableByteArray;

@JsonSerialize(using=TextSerializer.class)
public class Text
extends ReusableByteArray {
    private static ThreadLocal<CharsetEncoder> ENCODER_FACTORY = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
    };
    private static ThreadLocal<CharsetDecoder> DECODER_FACTORY = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
    };
    public static final int DEFAULT_MAX_LEN = 0x100000;
    private static final int LEAD_BYTE = 0;
    private static final int TRAIL_BYTE_1 = 1;
    private static final int TRAIL_BYTE = 2;
    static final int[] bytesFromUTF8 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5};
    static final int[] offsetsFromUTF8 = new int[]{0, 12416, 925824, 63447168, -100130688, -2113396608};

    public Text() {
    }

    public Text(String string) {
        this.set(string);
    }

    public Text(Text utf8) {
        this.set(utf8);
    }

    public Text(byte[] utf8) {
        this.set(utf8);
    }

    public byte[] copyBytes() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.bytes, 0, result, 0, this.length);
        return result;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int charAt(int position) {
        if (position > this.length) {
            return -1;
        }
        if (position < 0) {
            return -1;
        }
        ByteBuffer bb = ByteBuffer.wrap(this.bytes).position(position);
        return Text.bytesToCodePoint(bb.slice());
    }

    public int find(String what) {
        return this.find(what, 0);
    }

    public int find(String what, int start) {
        try {
            ByteBuffer src = ByteBuffer.wrap(this.bytes, 0, this.length);
            ByteBuffer tgt = Text.encode(what);
            byte b = tgt.get();
            src.position(start);
            while (src.hasRemaining()) {
                if (b != src.get()) continue;
                src.mark();
                tgt.mark();
                boolean found = true;
                int pos = src.position() - 1;
                while (tgt.hasRemaining()) {
                    if (!src.hasRemaining()) {
                        tgt.reset();
                        src.reset();
                        found = false;
                        break;
                    }
                    if (tgt.get() == src.get()) continue;
                    tgt.reset();
                    src.reset();
                    found = false;
                    break;
                }
                if (!found) continue;
                return pos;
            }
            return -1;
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void set(String string) {
        try {
            ByteBuffer bb = Text.encode(string, true);
            this.bytes = bb.array();
            this.length = bb.limit();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Should not have happened ", e);
        }
    }

    public void set(byte[] utf8) {
        this.set(utf8, 0, utf8.length);
    }

    public void set(Text other) {
        this.set(other.getBytes(), 0, (int)other.getLength());
    }

    public void set(byte[] utf8, int start, int len) {
        super.set(utf8, (long)start, (long)len);
    }

    public void append(byte[] utf8, int start, int len) {
        this.setCapacity(this.length + len, true);
        System.arraycopy(utf8, start, this.bytes, this.length, len);
        this.length += len;
    }

    public void clear() {
        this.length = 0;
    }

    @Override
    public String toString() {
        try {
            return Text.decode(this.bytes, 0, this.length);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Should not have happened ", e);
        }
    }

    public void readWithKnownLength(DataInput in, int len) throws IOException {
        this.setCapacity(len, false);
        in.readFully(this.bytes, 0, len);
        this.length = len;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Text)) {
            return false;
        }
        return super.equals(o);
    }

    public static String decode(byte[] utf8) throws CharacterCodingException {
        return Text.decode(ByteBuffer.wrap(utf8), true);
    }

    public static String decode(byte[] utf8, int start, int length) throws CharacterCodingException {
        return Text.decode(ByteBuffer.wrap(utf8, start, length), true);
    }

    public static String decode(byte[] utf8, int start, int length, boolean replace) throws CharacterCodingException {
        return Text.decode(ByteBuffer.wrap(utf8, start, length), replace);
    }

    private static String decode(ByteBuffer utf8, boolean replace) throws CharacterCodingException {
        CharsetDecoder decoder = DECODER_FACTORY.get();
        if (replace) {
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        String str = decoder.decode(utf8).toString();
        if (replace) {
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return str;
    }

    public static ByteBuffer encode(String string) throws CharacterCodingException {
        return Text.encode(string, true);
    }

    public static ByteBuffer encode(String string, boolean replace) throws CharacterCodingException {
        CharsetEncoder encoder = ENCODER_FACTORY.get();
        if (replace) {
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        ByteBuffer bytes = encoder.encode(CharBuffer.wrap(string.toCharArray()));
        if (replace) {
            encoder.onMalformedInput(CodingErrorAction.REPORT);
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return bytes;
    }

    public static boolean validateUTF8NoThrow(byte[] utf8) {
        return !Text.validateUTF8Internal(utf8, 0, utf8.length).isPresent();
    }

    public static void validateUTF8(byte[] utf8) throws MalformedInputException {
        Text.validateUTF8(utf8, 0, utf8.length);
    }

    public static void validateUTF8(byte[] utf8, int start, int len) throws MalformedInputException {
        Optional<Integer> result = Text.validateUTF8Internal(utf8, start, len);
        if (result.isPresent()) {
            throw new MalformedInputException(result.get());
        }
    }

    private static Optional<Integer> validateUTF8Internal(byte[] utf8, int start, int len) {
        int leadByte = 0;
        int length = 0;
        int state = 0;
        block11: for (int count = start; count < start + len; ++count) {
            int aByte = utf8[count] & 0xFF;
            switch (state) {
                case 0: {
                    leadByte = aByte;
                    length = bytesFromUTF8[aByte];
                    switch (length) {
                        case 0: {
                            if (leadByte <= 127) continue block11;
                            return Optional.of(count);
                        }
                        case 1: {
                            if (leadByte < 194 || leadByte > 223) {
                                return Optional.of(count);
                            }
                            state = 1;
                            continue block11;
                        }
                        case 2: {
                            if (leadByte < 224 || leadByte > 239) {
                                return Optional.of(count);
                            }
                            state = 1;
                            continue block11;
                        }
                        case 3: {
                            if (leadByte < 240 || leadByte > 244) {
                                return Optional.of(count);
                            }
                            state = 1;
                            continue block11;
                        }
                    }
                    return Optional.of(count);
                }
                case 1: {
                    if (leadByte == 240 && aByte < 144) {
                        return Optional.of(count);
                    }
                    if (leadByte == 244 && aByte > 143) {
                        return Optional.of(count);
                    }
                    if (leadByte == 224 && aByte < 160) {
                        return Optional.of(count);
                    }
                    if (leadByte == 237 && aByte > 159) {
                        return Optional.of(count);
                    }
                }
                case 2: {
                    if (aByte < 128 || aByte > 191) {
                        return Optional.of(count);
                    }
                    if (--length == 0) {
                        state = 0;
                        continue block11;
                    }
                    state = 2;
                    continue block11;
                }
            }
        }
        return Optional.empty();
    }

    public static int bytesToCodePoint(ByteBuffer bytes) {
        bytes.mark();
        byte b = bytes.get();
        bytes.reset();
        int extraBytesToRead = bytesFromUTF8[b & 0xFF];
        if (extraBytesToRead < 0) {
            return -1;
        }
        int ch = 0;
        switch (extraBytesToRead) {
            case 5: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 4: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 3: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 2: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 1: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 0: {
                ch += bytes.get() & 0xFF;
                break;
            }
        }
        return ch -= offsetsFromUTF8[extraBytesToRead];
    }

    public static int utf8Length(String string) {
        StringCharacterIterator iter = new StringCharacterIterator(string);
        char ch = iter.first();
        int size = 0;
        while (ch != '\uffff') {
            if (ch >= '\ud800' && ch < '\udc00') {
                char trail = iter.next();
                if (trail > '\udbff' && trail < '\ue000') {
                    size += 4;
                } else {
                    size += 3;
                    iter.previous();
                }
            } else {
                size = ch < '\u0080' ? ++size : (ch < '\u0800' ? (size += 2) : (size += 3));
            }
            ch = iter.next();
        }
        return size;
    }

    public static class TextSerializer
    extends StdSerializer<Text> {
        public TextSerializer() {
            super(Text.class);
        }

        @Override
        public void serialize(Text text, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeString(text.toString());
        }
    }
}

