/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector.util;

import java.util.function.BiFunction;
import shadow.palantir.driver.org.apache.arrow.util.Preconditions;
import shadow.palantir.driver.org.apache.arrow.vector.BaseFixedWidthVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.VectorSchemaRoot;
import shadow.palantir.driver.org.apache.arrow.vector.validate.ValidateUtil;
import shadow.palantir.driver.org.apache.arrow.vector.validate.ValidateVectorBufferVisitor;
import shadow.palantir.driver.org.apache.arrow.vector.validate.ValidateVectorDataVisitor;
import shadow.palantir.driver.org.apache.arrow.vector.validate.ValidateVectorTypeVisitor;

public class ValueVectorUtility {
    private ValueVectorUtility() {
    }

    public static <V extends ValueVector> String getToString(V vector, int start, int end) {
        return ValueVectorUtility.getToString(vector, start, end, (v, i) -> v.getObject((int)i));
    }

    public static <V extends ValueVector> String getToString(V vector, int start, int end, BiFunction<V, Integer, Object> valueToString) {
        Preconditions.checkNotNull(vector);
        int length = end - start;
        Preconditions.checkArgument(length >= 0);
        Preconditions.checkArgument(start >= 0);
        Preconditions.checkArgument(end <= vector.getValueCount());
        if (length == 0) {
            return "[]";
        }
        int window = 10;
        boolean skipComma = false;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = start; i < end; ++i) {
            if (skipComma) {
                skipComma = false;
            }
            if (i - start >= 10 && i < end - 10) {
                sb.append("...");
                i = end - 10 - 1;
                skipComma = true;
            } else {
                sb.append(valueToString.apply(vector, i));
            }
            if (i == end - 1) {
                sb.append(']');
                continue;
            }
            if (!skipComma) {
                sb.append(',');
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public static void validate(ValueVector vector) {
        Preconditions.checkNotNull(vector);
        ValidateVectorTypeVisitor typeVisitor = new ValidateVectorTypeVisitor();
        vector.accept(typeVisitor, null);
        ValidateVectorBufferVisitor bufferVisitor = new ValidateVectorBufferVisitor();
        vector.accept(bufferVisitor, null);
    }

    public static void validateFull(ValueVector vector) {
        ValueVectorUtility.validate(vector);
        ValidateVectorDataVisitor dataVisitor = new ValidateVectorDataVisitor();
        vector.accept(dataVisitor, null);
    }

    public static void validate(VectorSchemaRoot root) {
        Preconditions.checkNotNull(root);
        int valueCount = root.getRowCount();
        ValidateUtil.validateOrThrow(valueCount >= 0, "The row count of vector schema root %s is negative.", valueCount);
        for (ValueVector valueVector : root.getFieldVectors()) {
            ValidateUtil.validateOrThrow(valueCount == valueVector.getValueCount(), "Child vector and vector schema root have different value counts. Child vector value count %s, vector schema root value count %s", valueVector.getValueCount(), valueCount);
            ValueVectorUtility.validate(valueVector);
        }
    }

    public static void validateFull(VectorSchemaRoot root) {
        Preconditions.checkNotNull(root);
        int valueCount = root.getRowCount();
        ValidateUtil.validateOrThrow(valueCount >= 0, "The row count of vector schema root %s is negative.", valueCount);
        for (ValueVector valueVector : root.getFieldVectors()) {
            ValidateUtil.validateOrThrow(valueCount == valueVector.getValueCount(), "Child vector and vector schema root have different value counts. Child vector value count %s, vector schema root value count %s", valueVector.getValueCount(), valueCount);
            ValueVectorUtility.validateFull(valueVector);
        }
    }

    public static void preAllocate(VectorSchemaRoot root, int targetSize) {
        for (ValueVector valueVector : root.getFieldVectors()) {
            if (!(valueVector instanceof BaseFixedWidthVector)) continue;
            ((BaseFixedWidthVector)valueVector).allocateNew(targetSize);
        }
    }

    public static void ensureCapacity(VectorSchemaRoot root, int targetCapacity) {
        for (ValueVector valueVector : root.getFieldVectors()) {
            if (!(valueVector instanceof BaseFixedWidthVector)) continue;
            while (valueVector.getValueCapacity() < targetCapacity) {
                valueVector.reAlloc();
            }
        }
    }
}

