/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.hc.client5.http.protocol;

import java.io.IOException;
import shadow.palantir.driver.org.apache.hc.client5.http.config.RequestConfig;
import shadow.palantir.driver.org.apache.hc.client5.http.protocol.HttpClientContext;
import shadow.palantir.driver.org.apache.hc.core5.annotation.Contract;
import shadow.palantir.driver.org.apache.hc.core5.annotation.ThreadingBehavior;
import shadow.palantir.driver.org.apache.hc.core5.http.EntityDetails;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpException;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpRequest;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpRequestInterceptor;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpVersion;
import shadow.palantir.driver.org.apache.hc.core5.http.ProtocolVersion;
import shadow.palantir.driver.org.apache.hc.core5.http.protocol.HttpContext;
import shadow.palantir.driver.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect")) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion version;
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : HttpVersion.HTTP_1_1;
            if (entity != null && entity.getContentLength() != 0L && !version.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

