/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.hc.core5.http.impl.io;

import shadow.palantir.driver.org.apache.hc.core5.annotation.Contract;
import shadow.palantir.driver.org.apache.hc.core5.annotation.ThreadingBehavior;
import shadow.palantir.driver.org.apache.hc.core5.http.ClassicHttpResponse;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpResponseFactory;
import shadow.palantir.driver.org.apache.hc.core5.http.ReasonPhraseCatalog;
import shadow.palantir.driver.org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import shadow.palantir.driver.org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import shadow.palantir.driver.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultClassicHttpResponseFactory
implements HttpResponseFactory<ClassicHttpResponse> {
    public static final DefaultClassicHttpResponseFactory INSTANCE = new DefaultClassicHttpResponseFactory();
    private final ReasonPhraseCatalog reasonCatalog;

    public DefaultClassicHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultClassicHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public ClassicHttpResponse newHttpResponse(int status, String reasonPhrase) {
        return new BasicClassicHttpResponse(status, reasonPhrase);
    }

    @Override
    public ClassicHttpResponse newHttpResponse(int status) {
        return new BasicClassicHttpResponse(status, this.reasonCatalog, null);
    }
}

