/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.api;

import java.util.Collection;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.NoSuchElementException;
import shadow.palantir.driver.org.eclipse.collections.api.LazyByteIterable;
import shadow.palantir.driver.org.eclipse.collections.api.PrimitiveIterable;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableByteBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.comparator.primitive.ByteComparator;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.BooleanByteToBooleanFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteByteToByteFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToBooleanFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToCharFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToDoubleFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToFloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToIntFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToLongFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToShortFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharByteToCharFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.DoubleByteToDoubleFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.FloatByteToFloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.IntByteToIntFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.LongByteToLongFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ShortByteToShortFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.ByteIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableByteList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ByteSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableByteSet;

public interface ByteIterable
extends PrimitiveIterable {
    public ByteIterator byteIterator();

    public byte[] toArray();

    default public byte[] toArray(byte[] target) {
        return this.toList().toArray(target);
    }

    public boolean contains(byte var1);

    default public boolean containsAll(byte ... source) {
        if (this.size() <= 32 || source.length < 4) {
            for (byte item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }
        ByteSet set = this instanceof ByteSet ? (ByteSet)this : this.toSet();
        for (byte item : source) {
            if (set.contains(item)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(ByteIterable source) {
        if (this.size() <= 32 || source.size() < 4) {
            return source.allSatisfy(this::contains);
        }
        ByteSet set = this instanceof ByteSet ? (ByteSet)this : this.toSet();
        return source.allSatisfy(set::contains);
    }

    default public boolean containsAny(byte ... source) {
        ByteIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof ByteSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAny(ByteIterable source) {
        ByteIterable outside = this;
        ByteIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof ByteSet) {
            ByteIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof ByteSet)) {
            inside = inside.toSet();
        }
        return outside.anySatisfy(inside::contains);
    }

    default public boolean containsNone(byte ... source) {
        ByteIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof ByteSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return false;
        }
        return true;
    }

    default public boolean containsNone(ByteIterable source) {
        ByteIterable outside = this;
        ByteIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof ByteSet) {
            ByteIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof ByteSet)) {
            inside = inside.toSet();
        }
        return outside.noneSatisfy(inside::contains);
    }

    default public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure var1);

    default public ByteIterable tap(ByteProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public ByteIterable select(BytePredicate var1);

    public ByteIterable reject(BytePredicate var1);

    default public <R extends MutableByteCollection> R select(BytePredicate predicate, R target) {
        this.each(each -> {
            if (predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    default public <R extends MutableByteCollection> R reject(BytePredicate predicate, R target) {
        this.each(each -> {
            if (!predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(ByteToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(ByteToObjectFunction<? extends V> function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(ByteToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each -> {
            Iterable iterable = (Iterable)function.valueOf(each);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(ByteToBooleanFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(ByteToByteFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(ByteToCharFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(ByteToShortFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(ByteToIntFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(ByteToFloatFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(ByteToLongFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(ByteToDoubleFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    public byte detectIfNone(BytePredicate var1, byte var2);

    public int count(BytePredicate var1);

    public boolean anySatisfy(BytePredicate var1);

    public boolean allSatisfy(BytePredicate var1);

    default public boolean noneSatisfy(BytePredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public MutableByteList toList();

    public MutableByteSet toSet();

    public MutableByteBag toBag();

    public LazyByteIterable asLazy();

    public <T> T injectInto(T var1, ObjectByteToObjectFunction<? super T, ? extends T> var2);

    default public boolean injectIntoBoolean(boolean injectedValue, BooleanByteToBooleanFunction function) {
        boolean[] result = new boolean[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public byte injectIntoByte(byte injectedValue, ByteByteToByteFunction function) {
        byte[] result = new byte[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public char injectIntoChar(char injectedValue, CharByteToCharFunction function) {
        char[] result = new char[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public short injectIntoShort(short injectedValue, ShortByteToShortFunction function) {
        short[] result = new short[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public int injectIntoInt(int injectedValue, IntByteToIntFunction function) {
        int[] result = new int[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public float injectIntoFloat(float injectedValue, FloatByteToFloatFunction function) {
        float[] result = new float[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public long injectIntoLong(long injectedValue, LongByteToLongFunction function) {
        long[] result = new long[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public double injectIntoDouble(double injectedValue, DoubleByteToDoubleFunction function) {
        double[] result = new double[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public long reduceIfEmpty(LongByteToLongFunction accumulator, long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.reduce(accumulator);
    }

    default public long reduce(LongByteToLongFunction accumulator) {
        boolean[] seenOne = new boolean[1];
        long[] result = new long[1];
        this.each(each -> {
            if (seenOne[0]) {
                result[0] = accumulator.valueOf(result[0], each);
            } else {
                seenOne[0] = true;
                result[0] = each;
            }
        });
        if (!seenOne[0]) {
            throw new NoSuchElementException();
        }
        return result[0];
    }

    default public RichIterable<ByteIterable> chunk(int size) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public long sum();

    default public IntSummaryStatistics summaryStatistics() {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    public byte max();

    public byte maxIfEmpty(byte var1);

    public byte min();

    public byte minIfEmpty(byte var1);

    public double average();

    default public double averageIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.average();
    }

    public double median();

    default public double medianIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.median();
    }

    public byte[] toSortedArray();

    public MutableByteList toSortedList();

    default public MutableByteList toSortedList(ByteComparator comparator) {
        return this.toList().sortThis(comparator);
    }

    default public <T> MutableByteList toSortedListBy(ByteToObjectFunction<T> function) {
        return this.toList().sortThisBy(function);
    }

    default public <T> MutableByteList toSortedListBy(ByteToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.toList().sortThisBy(function, comparator);
    }
}

