/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.api;

import java.util.Collection;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.NoSuchElementException;
import shadow.palantir.driver.org.eclipse.collections.api.LazyCharIterable;
import shadow.palantir.driver.org.eclipse.collections.api.PrimitiveIterable;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableCharBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.comparator.primitive.CharComparator;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.BooleanCharToBooleanFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteCharToByteFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharCharToCharFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToBooleanFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToByteFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToDoubleFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToFloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToIntFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToLongFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToShortFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.DoubleCharToDoubleFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.FloatCharToFloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.IntCharToIntFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.LongCharToLongFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ShortCharToShortFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.CharIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableCharList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.CharSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableCharSet;

public interface CharIterable
extends PrimitiveIterable {
    public CharIterator charIterator();

    public char[] toArray();

    default public char[] toArray(char[] target) {
        return this.toList().toArray(target);
    }

    public boolean contains(char var1);

    default public boolean containsAll(char ... source) {
        if (this.size() <= 32 || source.length < 4) {
            for (char item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }
        CharSet set = this instanceof CharSet ? (CharSet)this : this.toSet();
        for (char item : source) {
            if (set.contains(item)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(CharIterable source) {
        if (this.size() <= 32 || source.size() < 4) {
            return source.allSatisfy(this::contains);
        }
        CharSet set = this instanceof CharSet ? (CharSet)this : this.toSet();
        return source.allSatisfy(set::contains);
    }

    default public boolean containsAny(char ... source) {
        CharIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof CharSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAny(CharIterable source) {
        CharIterable outside = this;
        CharIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof CharSet) {
            CharIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof CharSet)) {
            inside = inside.toSet();
        }
        return outside.anySatisfy(inside::contains);
    }

    default public boolean containsNone(char ... source) {
        CharIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof CharSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return false;
        }
        return true;
    }

    default public boolean containsNone(CharIterable source) {
        CharIterable outside = this;
        CharIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof CharSet) {
            CharIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof CharSet)) {
            inside = inside.toSet();
        }
        return outside.noneSatisfy(inside::contains);
    }

    default public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure var1);

    default public CharIterable tap(CharProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public CharIterable select(CharPredicate var1);

    public CharIterable reject(CharPredicate var1);

    default public <R extends MutableCharCollection> R select(CharPredicate predicate, R target) {
        this.each(each -> {
            if (predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    default public <R extends MutableCharCollection> R reject(CharPredicate predicate, R target) {
        this.each(each -> {
            if (!predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(CharToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(CharToObjectFunction<? extends V> function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(CharToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each -> {
            Iterable iterable = (Iterable)function.valueOf(each);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(CharToBooleanFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(CharToByteFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(CharToCharFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(CharToShortFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(CharToIntFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(CharToFloatFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(CharToLongFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(CharToDoubleFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    public char detectIfNone(CharPredicate var1, char var2);

    public int count(CharPredicate var1);

    public boolean anySatisfy(CharPredicate var1);

    public boolean allSatisfy(CharPredicate var1);

    default public boolean noneSatisfy(CharPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public MutableCharList toList();

    public MutableCharSet toSet();

    public MutableCharBag toBag();

    public LazyCharIterable asLazy();

    public <T> T injectInto(T var1, ObjectCharToObjectFunction<? super T, ? extends T> var2);

    default public boolean injectIntoBoolean(boolean injectedValue, BooleanCharToBooleanFunction function) {
        boolean[] result = new boolean[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public byte injectIntoByte(byte injectedValue, ByteCharToByteFunction function) {
        byte[] result = new byte[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public char injectIntoChar(char injectedValue, CharCharToCharFunction function) {
        char[] result = new char[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public short injectIntoShort(short injectedValue, ShortCharToShortFunction function) {
        short[] result = new short[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public int injectIntoInt(int injectedValue, IntCharToIntFunction function) {
        int[] result = new int[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public float injectIntoFloat(float injectedValue, FloatCharToFloatFunction function) {
        float[] result = new float[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public long injectIntoLong(long injectedValue, LongCharToLongFunction function) {
        long[] result = new long[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public double injectIntoDouble(double injectedValue, DoubleCharToDoubleFunction function) {
        double[] result = new double[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public long reduceIfEmpty(LongCharToLongFunction accumulator, long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.reduce(accumulator);
    }

    default public long reduce(LongCharToLongFunction accumulator) {
        boolean[] seenOne = new boolean[1];
        long[] result = new long[1];
        this.each(each -> {
            if (seenOne[0]) {
                result[0] = accumulator.valueOf(result[0], each);
            } else {
                seenOne[0] = true;
                result[0] = each;
            }
        });
        if (!seenOne[0]) {
            throw new NoSuchElementException();
        }
        return result[0];
    }

    default public RichIterable<CharIterable> chunk(int size) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public long sum();

    default public IntSummaryStatistics summaryStatistics() {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    public char max();

    public char maxIfEmpty(char var1);

    public char min();

    public char minIfEmpty(char var1);

    public double average();

    default public double averageIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.average();
    }

    public double median();

    default public double medianIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.median();
    }

    public char[] toSortedArray();

    public MutableCharList toSortedList();

    default public MutableCharList toSortedList(CharComparator comparator) {
        return this.toList().sortThis(comparator);
    }

    default public <T> MutableCharList toSortedListBy(CharToObjectFunction<T> function) {
        return this.toList().sortThisBy(function);
    }

    default public <T> MutableCharList toSortedListBy(CharToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.toList().sortThisBy(function, comparator);
    }
}

