/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.api.bag;

import shadow.palantir.driver.org.eclipse.collections.api.bag.ImmutableBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.MutableBagIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.UnsortedBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableByteBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableCharBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableIntBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableLongBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableShortBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function2;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.IntFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.LongFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ShortFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate2;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Sets;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.BooleanBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ByteBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.CharBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.DoubleBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.FloatBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.IntBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.LongBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortBags;
import shadow.palantir.driver.org.eclipse.collections.api.map.MutableMap;
import shadow.palantir.driver.org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import shadow.palantir.driver.org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import shadow.palantir.driver.org.eclipse.collections.api.set.MutableSet;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.Pair;

public interface MutableBag<T>
extends UnsortedBag<T>,
MutableBagIterable<T> {
    @Override
    public MutableMap<T, Integer> toMapOfItemToCount();

    @Override
    public MutableBag<T> selectByOccurrences(IntPredicate var1);

    @Override
    default public MutableBag<T> selectDuplicates() {
        return this.selectByOccurrences(occurrences -> occurrences > 1);
    }

    @Override
    default public MutableSet<T> selectUnique() {
        MutableSet result = Sets.mutable.empty();
        this.forEachWithOccurrences((each, occurrences) -> {
            if (occurrences == 1) {
                result.add(each);
            }
        });
        return result;
    }

    @Override
    default public MutableBag<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    default public MutableBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    default public MutableBag<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    default public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    public MutableBag<T> newEmpty();

    @Override
    public MutableBag<T> asUnmodifiable();

    @Override
    public MutableBag<T> asSynchronized();

    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <V> MutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.collect((Function)function);
    }

    @Override
    default public <V, P> MutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith((Function2)function, (Object)parameter);
    }

    @Override
    default public <V> MutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect((Function)function);
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex();

    @Override
    public MutableBag<T> tap(Procedure<? super T> var1);

    @Override
    public MutableBag<T> select(Predicate<? super T> var1);

    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public MutableBag<T> reject(Predicate<? super T> var1);

    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> var1);

    @Override
    default public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, ByteBags.mutable.empty());
    }

    @Override
    default public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, CharBags.mutable.empty());
    }

    @Override
    default public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, IntBags.mutable.empty());
    }

    @Override
    default public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, BooleanBags.mutable.empty());
    }

    @Override
    default public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, DoubleBags.mutable.empty());
    }

    @Override
    default public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, FloatBags.mutable.empty());
    }

    @Override
    default public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, LongBags.mutable.empty());
    }

    @Override
    default public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, ShortBags.mutable.empty());
    }

    @Override
    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> var1);

    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> MutableBag<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public ImmutableBag<T> toImmutable();

    @Override
    default public ImmutableBag<T> toImmutableBag() {
        return this.toImmutable();
    }
}

