/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.api.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import shadow.palantir.driver.org.eclipse.collections.api.factory.ThrowingInvocationHandler;

public final class ServiceLoaderUtils {
    private static final Map<String, String> FACTORY_IMPL = new HashMap<String, String>();

    private ServiceLoaderUtils() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> T loadServiceClass(Class<T> serviceClass) {
        T result = ServiceLoaderUtils.loadServiceClass(serviceClass, Thread.currentThread().getContextClassLoader());
        if (result == null) {
            result = ServiceLoaderUtils.loadServiceClass(serviceClass, ServiceLoaderUtils.class.getClassLoader());
        }
        if (result == null) {
            result = ServiceLoaderUtils.loadByReflection(serviceClass, Thread.currentThread().getContextClassLoader());
        }
        if (result == null) {
            result = ServiceLoaderUtils.loadByReflection(serviceClass, ServiceLoaderUtils.class.getClassLoader());
        }
        if (result == null) {
            String message = "Could not find any implementations of " + serviceClass.getSimpleName() + ". Check that eclipse-collections.jar is on the classpath and that its META-INF/services directory is intact.";
            result = ServiceLoaderUtils.createProxyInstance(serviceClass, message);
        }
        return result;
    }

    private static <T> T loadServiceClass(Class<T> serviceClass, ClassLoader loader) {
        ArrayList<T> factories = new ArrayList<T>();
        for (T factory : ServiceLoader.load(serviceClass, loader)) {
            factories.add(factory);
        }
        if (factories.isEmpty()) {
            return null;
        }
        if (factories.size() > 1) {
            String message = String.format("Found multiple implementations of %s on the classpath. Check that there is only one copy of eclipse-collections.jar on the classpath. Found implementations: %s.", serviceClass.getSimpleName(), factories.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")));
            return ServiceLoaderUtils.createProxyInstance(serviceClass, message);
        }
        return (T)factories.get(0);
    }

    private static <T> T loadByReflection(Class<T> serviceClass, ClassLoader loader) {
        String fallbackName = FACTORY_IMPL.get(serviceClass.getName());
        try {
            Class<?> fallbackClass = Class.forName(fallbackName, true, loader);
            return (T)fallbackClass.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T> T createProxyInstance(Class<T> serviceClass, String message) {
        ThrowingInvocationHandler handler = new ThrowingInvocationHandler(message);
        Object proxyInstance = Proxy.newProxyInstance(serviceClass.getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)handler);
        return serviceClass.cast(proxyInstance);
    }

    static {
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.ImmutableBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.ImmutableBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.MultiReaderBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.MultiReaderMutableBagFactory");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.MutableBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.MutableBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.ImmutableBooleanBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.ImmutableByteBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableByteBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.ImmutableCharBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableCharBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.ImmutableDoubleBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.ImmutableFloatBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.ImmutableIntBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.ImmutableLongBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableLongBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.ImmutableShortBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableShortBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.MutableBooleanBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.MutableBooleanBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.MutableByteBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.MutableByteBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.MutableCharBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.MutableCharBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.MutableDoubleBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.MutableDoubleBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.MutableFloatBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.MutableFloatBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.MutableIntBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.MutableIntBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.MutableLongBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.MutableLongBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.MutableShortBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.MutableShortBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.sorted.ImmutableSortedBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.sorted.immutable.ImmutableSortedBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bag.sorted.MutableSortedBagFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bag.sorted.mutable.MutableSortedBagFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bimap.ImmutableBiMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bimap.immutable.ImmutableBiMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.bimap.MutableBiMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.bimap.mutable.MutableBiMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.FixedSizeListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.fixed.FixedSizeListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.ImmutableListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.immutable.ImmutableListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.MultiReaderListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.MultiReaderMutableListFactory");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.MutableListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.MutableListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.ImmutableBooleanListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.immutable.primitive.ImmutableBooleanListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.ImmutableByteListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.immutable.primitive.ImmutableByteListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.ImmutableCharListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.ImmutableDoubleListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.immutable.primitive.ImmutableDoubleListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.ImmutableFloatListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.immutable.primitive.ImmutableFloatListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.ImmutableIntListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.immutable.primitive.ImmutableIntListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.ImmutableLongListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.immutable.primitive.ImmutableLongListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.ImmutableShortListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.immutable.primitive.ImmutableShortListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableBooleanListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.MutableBooleanListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableByteListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.MutableByteListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableCharListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.MutableCharListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableDoubleListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.MutableDoubleListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableFloatListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.MutableFloatListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableIntListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.MutableIntListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableLongListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.MutableLongListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableShortListFactory", "shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.MutableShortListFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.FixedSizeMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.fixed.FixedSizeMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.ImmutableMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.ImmutableMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.MutableMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.MutableMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableBooleanBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableBooleanBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableBooleanByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableBooleanByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableBooleanCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableBooleanCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableBooleanDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableBooleanDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableBooleanFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableBooleanFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableBooleanIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableBooleanIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableBooleanLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableBooleanLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableBooleanShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableBooleanShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableByteBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableByteByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableByteCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableByteDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableByteFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableByteIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableByteLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableByteObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableByteShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableCharBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableCharByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableCharCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableCharDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableCharFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableCharIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableCharLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableCharObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableCharShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableFloatBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableFloatByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableFloatCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableFloatDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableFloatFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableFloatIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableFloatLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableFloatObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableFloatShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableIntBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableIntByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableIntCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableIntDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableIntFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableIntIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableIntLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableIntObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableIntShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableLongBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableLongByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableLongCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableLongDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableLongFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableLongIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableLongLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableLongObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableLongShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableObjectBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableObjectByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableObjectCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableObjectDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableObjectFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableObjectIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableObjectLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableObjectShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableShortBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableShortByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableShortCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableShortDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableShortFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableShortIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableShortLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableShortObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.ImmutableShortShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableBooleanBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableBooleanBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableBooleanByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableBooleanByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableBooleanCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableBooleanCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableBooleanDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableBooleanDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableBooleanFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableBooleanFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableBooleanIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableBooleanIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableBooleanLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableBooleanLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableBooleanShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableBooleanShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableByteBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableByteByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableByteCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableByteDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableByteFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableByteIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableByteLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableByteObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableByteShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableCharBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableCharBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableCharByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableCharByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableCharCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableCharCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableCharDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableCharDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableCharFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableCharFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableCharIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableCharIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableCharLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableCharLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableCharObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableCharObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableCharShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableCharShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableDoubleBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableDoubleByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableDoubleCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableDoubleDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableDoubleFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableDoubleIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableDoubleLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableDoubleObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableDoubleShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableFloatBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableFloatBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableFloatByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableFloatByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableFloatCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableFloatCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableFloatDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableFloatDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableFloatFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableFloatFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableFloatIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableFloatIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableFloatLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableFloatLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableFloatObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableFloatObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableFloatShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableFloatShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableIntBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableIntBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableIntByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableIntByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableIntCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableIntCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableIntDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableIntDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableIntFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableIntFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableIntIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableIntIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableIntLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableIntLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableIntObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableIntObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableIntShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableIntShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableLongBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableLongBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableLongByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableLongByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableLongCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableLongCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableLongDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableLongDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableLongFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableLongFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableLongIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableLongIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableLongLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableLongLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableLongObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableLongObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableLongShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableLongShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectBooleanHashingStrategyMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectBooleanHashingStrategyMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectByteHashingStrategyMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectByteHashingStrategyMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectCharHashingStrategyMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectCharHashingStrategyMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectDoubleHashingStrategyMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectDoubleHashingStrategyMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectFloatHashingStrategyMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectFloatHashingStrategyMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectIntHashingStrategyMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectIntHashingStrategyMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectLongHashingStrategyMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectLongHashingStrategyMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectShortHashingStrategyMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectShortHashingStrategyMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableObjectShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableObjectShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableShortBooleanMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableShortBooleanMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableShortByteMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableShortByteMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableShortCharMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableShortCharMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableShortDoubleMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableShortDoubleMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableShortFloatMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableShortFloatMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableShortIntMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableShortIntMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableShortLongMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableShortLongMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableShortObjectMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableShortObjectMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.primitive.MutableShortShortMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableShortShortMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.sorted.ImmutableSortedMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.sorted.immutable.ImmutableSortedMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.map.sorted.MutableSortedMapFactory", "shadow.palantir.driver.org.eclipse.collections.impl.map.sorted.mutable.MutableSortedMapFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.FixedSizeSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.fixed.FixedSizeSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.ImmutableSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.ImmutableSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.MultiReaderSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.MultiReaderMutableSetFactory");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.MutableSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.MutableSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableBooleanSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableByteSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableByteSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableCharSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableCharSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableDoubleSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableDoubleSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableFloatSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableFloatSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableIntSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableLongSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableLongSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableShortSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableShortSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.MutableBooleanSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.MutableBooleanSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.MutableByteSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.MutableByteSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.MutableCharSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.MutableCharSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.MutableDoubleSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.MutableDoubleSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.MutableFloatSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.MutableFloatSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.MutableIntSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.MutableIntSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.MutableLongSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.MutableLongSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.MutableShortSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.MutableShortSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.sorted.ImmutableSortedSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.sorted.immutable.ImmutableSortedSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.set.sorted.MutableSortedSetFactory", "shadow.palantir.driver.org.eclipse.collections.impl.set.sorted.mutable.MutableSortedSetFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.ImmutableStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.immutable.ImmutableStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.MutableStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.MutableStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.ImmutableBooleanStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableBooleanStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.ImmutableByteStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableByteStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.ImmutableCharStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableCharStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.ImmutableDoubleStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableDoubleStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.ImmutableFloatStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableFloatStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.ImmutableIntStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableIntStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.ImmutableLongStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableLongStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.ImmutableShortStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableShortStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.MutableBooleanStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.primitive.MutableBooleanStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.MutableByteStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.primitive.MutableByteStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.MutableCharStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.primitive.MutableCharStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.MutableDoubleStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.primitive.MutableDoubleStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.MutableFloatStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.primitive.MutableFloatStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.MutableIntStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.primitive.MutableIntStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.MutableLongStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.primitive.MutableLongStackFactoryImpl");
        FACTORY_IMPL.put("shadow.palantir.driver.org.eclipse.collections.api.factory.stack.primitive.MutableShortStackFactory", "shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.primitive.MutableShortStackFactoryImpl");
    }
}

