/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.api.list;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import shadow.palantir.driver.org.eclipse.collections.api.block.HashingStrategy;
import shadow.palantir.driver.org.eclipse.collections.api.block.factory.SerializableComparators;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function2;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.IntFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.LongFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ShortFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate2;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.MutableCollection;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Lists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.BooleanLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ByteLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.CharLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.DoubleLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.FloatLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.IntLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.LongLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortLists;
import shadow.palantir.driver.org.eclipse.collections.api.list.ImmutableList;
import shadow.palantir.driver.org.eclipse.collections.api.list.ListIterable;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableBooleanList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableByteList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableCharList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableDoubleList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableFloatList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableIntList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableLongList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableShortList;
import shadow.palantir.driver.org.eclipse.collections.api.multimap.list.MutableListMultimap;
import shadow.palantir.driver.org.eclipse.collections.api.partition.list.PartitionMutableList;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.Pair;

public interface MutableList<T>
extends MutableCollection<T>,
List<T>,
Cloneable,
ListIterable<T> {
    @Override
    default public MutableList<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    default public MutableList<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    default public MutableList<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    default public MutableList<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    public MutableList<T> newEmpty();

    public MutableList<T> clone();

    @Override
    default public MutableList<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    default public MutableList<T> select(Predicate<? super T> predicate) {
        return (MutableList)this.select(predicate, this.newEmpty());
    }

    @Override
    default public <P> MutableList<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableList)this.selectWith(predicate, parameter, this.newEmpty());
    }

    @Override
    default public MutableList<T> reject(Predicate<? super T> predicate) {
        return (MutableList)this.reject(predicate, this.newEmpty());
    }

    @Override
    default public <P> MutableList<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableList)this.rejectWith(predicate, parameter, this.newEmpty());
    }

    @Override
    public PartitionMutableList<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> MutableList<S> selectInstancesOf(Class<S> var1);

    @Override
    default public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, Lists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public <V> MutableList<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each, n);
        });
    }

    @Override
    default public MutableList<T> selectWithIndex(ObjectIntPredicate<? super T> predicate) {
        int[] index = new int[]{0};
        return this.select((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public MutableList<T> rejectWithIndex(ObjectIntPredicate<? super T> predicate) {
        int[] index = new int[]{0};
        return this.reject((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, BooleanLists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, ByteLists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public MutableCharList collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, CharLists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, DoubleLists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, FloatLists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public MutableIntList collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, IntLists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public MutableLongList collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, LongLists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, ShortLists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, Lists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, Lists.mutable.empty());
    }

    @Override
    default public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, Lists.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public <P, V> MutableList<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public MutableList<T> distinct();

    @Override
    public MutableList<T> distinct(HashingStrategy<? super T> var1);

    @Override
    public <V> MutableList<T> distinctBy(Function<? super T, ? extends V> var1);

    default public MutableList<T> sortThis(Comparator<? super T> comparator) {
        this.sort(comparator);
        return this;
    }

    default public MutableList<T> sortThis() {
        return this.sortThis(null);
    }

    default public <V extends Comparable<? super V>> MutableList<T> sortThisBy(Function<? super T, ? extends V> function) {
        return this.sortThis(SerializableComparators.byFunction(function));
    }

    public MutableList<T> sortThisByInt(IntFunction<? super T> var1);

    public MutableList<T> sortThisByBoolean(BooleanFunction<? super T> var1);

    public MutableList<T> sortThisByChar(CharFunction<? super T> var1);

    public MutableList<T> sortThisByByte(ByteFunction<? super T> var1);

    public MutableList<T> sortThisByShort(ShortFunction<? super T> var1);

    public MutableList<T> sortThisByFloat(FloatFunction<? super T> var1);

    public MutableList<T> sortThisByLong(LongFunction<? super T> var1);

    public MutableList<T> sortThisByDouble(DoubleFunction<? super T> var1);

    @Override
    public MutableList<T> subList(int var1, int var2);

    @Override
    public MutableList<T> asUnmodifiable();

    @Override
    public MutableList<T> asSynchronized();

    @Override
    default public ImmutableList<T> toImmutable() {
        return Lists.immutable.withAll(this);
    }

    @Override
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public MutableList<Pair<T, Integer>> zipWithIndex();

    @Override
    public MutableList<T> take(int var1);

    @Override
    public MutableList<T> takeWhile(Predicate<? super T> var1);

    @Override
    public MutableList<T> drop(int var1);

    @Override
    public MutableList<T> dropWhile(Predicate<? super T> var1);

    @Override
    public PartitionMutableList<T> partitionWhile(Predicate<? super T> var1);

    @Override
    default public MutableList<T> toReversed() {
        return this.toList().reverseThis();
    }

    default public MutableList<T> reverseThis() {
        Collections.reverse(this);
        return this;
    }

    default public MutableList<T> shuffleThis() {
        Collections.shuffle(this);
        return this;
    }

    default public MutableList<T> shuffleThis(Random random) {
        Collections.shuffle(this, random);
        return this;
    }

    @Override
    default public ImmutableList<T> toImmutableList() {
        return this.toImmutable();
    }
}

