/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.IntFunction;

public final class Counter
implements Externalizable {
    public static final IntFunction<Counter> TO_COUNT = Counter::getCount;
    private static final long serialVersionUID = 1L;
    private int count;

    public Counter(int startCount) {
        this.count = startCount;
    }

    public Counter() {
        this(0);
    }

    public void increment() {
        ++this.count;
    }

    public void decrement() {
        --this.count;
    }

    public void add(int value) {
        this.count += value;
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public String toString() {
        return String.valueOf(this.count);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Counter)) {
            return false;
        }
        Counter counter2 = (Counter)o;
        return this.count == counter2.count;
    }

    public int hashCode() {
        return this.count;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.count);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.count = in.readInt();
    }
}

