/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import shadow.palantir.driver.org.eclipse.collections.api.bag.ImmutableBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.ImmutableBagIterable;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function2;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.IntFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.LongFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.collection.MutableCollection;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Bags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Sets;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ObjectDoubleMaps;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ObjectLongMaps;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import shadow.palantir.driver.org.eclipse.collections.impl.bag.AbstractBag;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.PrimitiveFunctions;

public abstract class AbstractImmutableBagIterable<T>
extends AbstractBag<T>
implements ImmutableBagIterable<T> {
    @Override
    public <V> ImmutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        this.forEachWithOccurrences((each, occurrences) -> result.addToValue(groupBy.valueOf(each), (long)function.intValueOf(each) * (long)occurrences));
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function)).toImmutable();
    }

    @Override
    public <V> ImmutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        this.forEachWithOccurrences((each, occurrences) -> result.addToValue(groupBy.valueOf(each), function.longValueOf(each) * (long)occurrences));
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function)).toImmutable();
    }

    protected void removeAllFrom(Iterable<? extends T> elements, MutableCollection<T> result) {
        if (elements instanceof Set) {
            result.removeAll((Set)elements);
        } else if (elements instanceof List) {
            List toBeRemoved = (List)elements;
            if (this.size() * toBeRemoved.size() > 10000) {
                result.removeAll(Sets.mutable.withAll(elements));
            } else {
                result.removeAll(toBeRemoved);
            }
        } else {
            result.removeAll(Sets.mutable.withAll(elements));
        }
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public <V> ImmutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.countBy(function, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public <V, P> ImmutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.countByWith(function, parameter, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.countByEach(function, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this, 0);
    }

    @Override
    public Collection<T> castToCollection() {
        return this;
    }

    protected boolean shortCircuit(T[] elements, int[] occurrences, ObjectIntPredicate<? super T> predicate, boolean expected, boolean onShortCircuit, boolean atEnd) {
        for (int i = 0; i < elements.length; ++i) {
            T each = elements[i];
            if (predicate.accept(each, occurrences[i]) != expected) continue;
            return onShortCircuit;
        }
        return atEnd;
    }
}

