/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import shadow.palantir.driver.org.eclipse.collections.api.BooleanIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyBooleanIterable;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.ImmutableBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.BooleanBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.BooleanIntProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.MutableCollection;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.BooleanIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.ImmutableList;
import shadow.palantir.driver.org.eclipse.collections.api.list.MutableList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableBooleanList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.primitive.BooleanIntPair;
import shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedBooleanIntProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.Lists;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.BooleanBags;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.BooleanSets;
import shadow.palantir.driver.org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;

final class ImmutableBooleanHashBag
implements ImmutableBooleanBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableBooleanBag delegate;

    private ImmutableBooleanHashBag(boolean[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = BooleanHashBag.newBagWith(newElements);
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use BooleanBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableBooleanHashBag newBagWith(boolean ... elements) {
        return new ImmutableBooleanHashBag(elements);
    }

    @Override
    public ImmutableBooleanBag newWith(boolean element) {
        return BooleanHashBag.newBag(this.delegate).with(element).toImmutable();
    }

    @Override
    public ImmutableBooleanBag newWithout(boolean element) {
        BooleanHashBag hashBag = BooleanHashBag.newBag(this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    @Override
    public ImmutableBooleanBag newWithAll(BooleanIterable elements) {
        BooleanHashBag bag = BooleanHashBag.newBag(this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    @Override
    public ImmutableBooleanBag newWithoutAll(BooleanIterable elements) {
        BooleanHashBag bag = BooleanHashBag.newBag(this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public boolean contains(boolean value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(boolean ... elements) {
        return this.delegate.containsAll(elements);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public ImmutableBooleanBag select(BooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableBooleanBag selectByOccurrences(IntPredicate predicate) {
        return this.delegate.selectByOccurrences(predicate).toImmutable();
    }

    @Override
    public ImmutableBooleanSet selectUnique() {
        MutableBooleanSet result = BooleanSets.mutable.empty();
        this.forEachWithOccurrences((each, occurrences) -> {
            if (occurrences == 1) {
                result.add(each);
            }
        });
        return result.toImmutable();
    }

    @Override
    public ImmutableList<BooleanIntPair> topOccurrences(int count) {
        return this.delegate.topOccurrences(count).toImmutable();
    }

    @Override
    public ImmutableList<BooleanIntPair> bottomOccurrences(int count) {
        return this.delegate.bottomOccurrences(count).toImmutable();
    }

    @Override
    public ImmutableBooleanBag reject(BooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        MutableCollection bag = this.delegate.collect((BooleanToObjectFunction)function);
        return bag.toImmutable();
    }

    @Override
    public MutableBooleanList toList() {
        return this.delegate.toList();
    }

    @Override
    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    @Override
    public int occurrencesOf(boolean item) {
        return this.delegate.occurrencesOf(item);
    }

    @Override
    public void forEachWithOccurrences(BooleanIntProcedure booleanIntProcedure) {
        this.delegate.forEachWithOccurrences(booleanIntProcedure);
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<BooleanIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                BooleanIterator iterator = this.booleanIterator();
                while (iterator.hasNext()) {
                    MutableBooleanBag batch = BooleanBags.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public MutableBooleanSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableBooleanBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public ImmutableBooleanBag toImmutable() {
        return this;
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public boolean[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean[] toArray(boolean[] target) {
        return this.delegate.toArray(target);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator(this.delegate.booleanIterator());
    }

    private Object writeReplace() {
        return new ImmutableBooleanBagSerializationProxy(this);
    }

    protected static class ImmutableBooleanBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private BooleanBag bag;

        public ImmutableBooleanBagSerializationProxy() {
        }

        protected ImmutableBooleanBagSerializationProxy(BooleanBag bag) {
            this.bag = bag;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences(new CheckedBooleanIntProcedure(){

                    @Override
                    public void safeValue(boolean item, int count) throws IOException {
                        out.writeBoolean(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            BooleanHashBag deserializedBag = new BooleanHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readBoolean(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

