/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive;

import java.util.stream.IntStream;
import shadow.palantir.driver.org.eclipse.collections.api.IntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.ImmutableIntBagFactory;
import shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntEmptyBag;
import shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntHashBag;
import shadow.palantir.driver.org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntSingletonBag;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.IntBags;

public class ImmutableIntBagFactoryImpl
implements ImmutableIntBagFactory {
    public static final ImmutableIntBagFactory INSTANCE = new ImmutableIntBagFactoryImpl();

    @Override
    public ImmutableIntBag empty() {
        return ImmutableIntEmptyBag.INSTANCE;
    }

    @Override
    public ImmutableIntBag of() {
        return this.empty();
    }

    @Override
    public ImmutableIntBag with() {
        return this.empty();
    }

    @Override
    public ImmutableIntBag of(int one) {
        return this.with(one);
    }

    @Override
    public ImmutableIntBag with(int one) {
        return new ImmutableIntSingletonBag(one);
    }

    @Override
    public ImmutableIntBag of(int ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableIntBag with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntHashBag.newBagWith(items);
    }

    @Override
    public ImmutableIntBag ofAll(IntIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableIntBag withAll(IntIterable items) {
        if (items instanceof ImmutableIntBag) {
            return (ImmutableIntBag)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableIntBag ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableIntBag withAll(Iterable<Integer> iterable) {
        return IntBags.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableIntBag ofAll(IntStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableIntBag withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

