/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive;

import java.util.stream.IntStream;
import shadow.palantir.driver.org.eclipse.collections.api.IntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableIntBag;
import shadow.palantir.driver.org.eclipse.collections.api.factory.bag.primitive.MutableIntBagFactory;
import shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.IntBags;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.Iterate;

public class MutableIntBagFactoryImpl
implements MutableIntBagFactory {
    public static final MutableIntBagFactory INSTANCE = new MutableIntBagFactoryImpl();

    @Override
    public MutableIntBag empty() {
        return new IntHashBag();
    }

    @Override
    public MutableIntBag of() {
        return this.empty();
    }

    @Override
    public MutableIntBag with() {
        return this.empty();
    }

    @Override
    public MutableIntBag of(int ... items) {
        return this.with(items);
    }

    @Override
    public MutableIntBag with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return IntHashBag.newBagWith(items);
    }

    @Override
    public MutableIntBag ofAll(IntIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableIntBag withAll(IntIterable items) {
        return IntHashBag.newBag(items);
    }

    @Override
    public MutableIntBag ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableIntBag withAll(Iterable<Integer> iterable) {
        return Iterate.collectInt(iterable, Integer::intValue, IntBags.mutable.empty());
    }

    @Override
    public MutableIntBag ofAll(IntStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableIntBag withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

