/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.block.factory;

import java.io.IOException;
import java.io.PrintStream;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function2;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure2;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.CaseProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.IfProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.checked.ThrowingProcedure;

public final class Procedures {
    private Procedures() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> Procedure<T> cast(Procedure<T> procedure) {
        return procedure;
    }

    public static <T> Procedure<T> println(PrintStream stream) {
        return new PrintlnProcedure(stream);
    }

    public static <T> Procedure<T> append(Appendable appendable) {
        return new AppendProcedure(appendable);
    }

    public static <T> Procedure<T> throwing(ThrowingProcedure<T> throwingProcedure) {
        return new ThrowingProcedureAdapter(throwingProcedure);
    }

    public static <T> Procedure<T> throwing(ThrowingProcedure<T> throwingProcedure, Function2<T, ? super Throwable, ? extends RuntimeException> rethrow) {
        return each -> {
            try {
                throwingProcedure.safeValue(each);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw (RuntimeException)rethrow.value(each, t);
            }
        };
    }

    @Deprecated
    public static <T> Procedure<T> fromProcedureWithInt(ObjectIntProcedure<? super T> objectIntProcedure) {
        return Procedures.fromObjectIntProcedure(objectIntProcedure);
    }

    public static <T> Procedure<T> fromObjectIntProcedure(ObjectIntProcedure<? super T> objectIntProcedure) {
        return new ObjectIntProcedureAdapter(objectIntProcedure);
    }

    public static <T> Procedure<T> ifTrue(Predicate<? super T> predicate, Procedure<? super T> block) {
        return new IfProcedure<T>(predicate, block);
    }

    public static <T> Procedure<T> ifElse(Predicate<? super T> predicate, Procedure<? super T> trueProcedure, Procedure<? super T> falseProcedure) {
        return new IfProcedure<T>(predicate, trueProcedure, falseProcedure);
    }

    public static <T> CaseProcedure<T> caseDefault(Procedure<? super T> defaultProcedure) {
        return new CaseProcedure<T>(defaultProcedure);
    }

    public static <T> CaseProcedure<T> caseDefault(Procedure<? super T> defaultProcedure, Predicate<? super T> predicate, Procedure<? super T> procedure) {
        return Procedures.caseDefault(defaultProcedure).addCase(predicate, procedure);
    }

    public static <T> Procedure<T> synchronizedEach(Procedure<T> procedure) {
        return new SynchronizedProcedure(procedure);
    }

    public static <T, P> Procedure<T> bind(Procedure2<? super T, ? super P> procedure, P parameter) {
        return new BindProcedure(procedure, parameter);
    }

    public static <T> Procedure<T> noop() {
        return NoopProcedure.INSTANCE;
    }

    private static enum NoopProcedure implements Procedure<Object>
    {
        INSTANCE;

        private static final long serialVersionUID = 1L;

        @Override
        public void value(Object each) {
        }
    }

    private static final class ThrowingProcedureAdapter<T>
    extends CheckedProcedure<T> {
        private static final long serialVersionUID = 1L;
        private final ThrowingProcedure<T> throwingProcedure;

        private ThrowingProcedureAdapter(ThrowingProcedure<T> throwingProcedure) {
            this.throwingProcedure = throwingProcedure;
        }

        @Override
        public void safeValue(T object) throws Exception {
            this.throwingProcedure.safeValue(object);
        }
    }

    private static final class BindProcedure<T, P>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final Procedure2<? super T, ? super P> procedure;
        private final P parameter;

        private BindProcedure(Procedure2<? super T, ? super P> procedure, P parameter) {
            this.procedure = procedure;
            this.parameter = parameter;
        }

        @Override
        public void value(T each) {
            this.procedure.value(each, this.parameter);
        }
    }

    public static final class SynchronizedProcedure<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final Procedure<T> procedure;

        private SynchronizedProcedure(Procedure<T> procedure) {
            this.procedure = procedure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void value(T each) {
            if (each == null) {
                this.procedure.value(null);
            } else {
                T t = each;
                synchronized (t) {
                    this.procedure.value(each);
                }
            }
        }
    }

    private static final class ObjectIntProcedureAdapter<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 2L;
        private int count;
        private final ObjectIntProcedure<? super T> objectIntProcedure;

        private ObjectIntProcedureAdapter(ObjectIntProcedure<? super T> objectIntProcedure) {
            this.objectIntProcedure = objectIntProcedure;
        }

        @Override
        public void value(T each) {
            this.objectIntProcedure.value(each, this.count);
            ++this.count;
        }
    }

    private static final class AppendProcedure<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final Appendable appendable;

        private AppendProcedure(Appendable appendable) {
            this.appendable = appendable;
        }

        @Override
        public void value(T each) {
            try {
                this.appendable.append(String.valueOf(each));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.appendable.toString();
        }
    }

    private static final class PrintlnProcedure<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final PrintStream stream;

        private PrintlnProcedure(PrintStream stream) {
            this.stream = stream;
        }

        @Override
        public void value(T each) {
            this.stream.println(each);
        }
    }
}

