/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.block.procedure;

import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.DoubleSumResultHolder;

public class SumOfFloatProcedure<T>
implements Procedure<T>,
DoubleSumResultHolder {
    private static final long serialVersionUID = 2L;
    private final FloatFunction<? super T> function;
    private double result;
    private double compensation;

    public SumOfFloatProcedure(FloatFunction<? super T> function) {
        this.function = function;
    }

    @Override
    public double getResult() {
        return this.result;
    }

    @Override
    public double getCompensation() {
        return this.compensation;
    }

    @Override
    public void value(T each) {
        double adjustedValue = (double)this.function.floatValueOf(each) - this.compensation;
        double nextSum = this.result + adjustedValue;
        this.compensation = nextSum - this.result - adjustedValue;
        this.result = nextSum;
    }
}

