/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure2;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.iterator.TakeIterator;

public class TakeIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final int count;

    public TakeIterable(Iterable<T> newAdapted, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        this.adapted = newAdapted;
        this.count = count;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next());
        }
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> procedure) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next(), i);
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterator<T> iterator = this.adapted.iterator();
        for (int i = 0; i < this.count && iterator.hasNext(); ++i) {
            procedure.value(iterator.next(), parameter);
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.count];
        this.forEachWithIndex((each, index) -> {
            result[index] = each;
        });
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new TakeIterator<T>(this.adapted, this.count);
    }
}

