/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list;

import shadow.palantir.driver.org.eclipse.collections.api.annotation.Beta;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.Functions;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.AbstractBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.Batch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.DistinctBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.FlatCollectListBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.ListBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.SelectListBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;

@Beta
public class CollectListBatch<T, V>
extends AbstractBatch<V>
implements ListBatch<V> {
    private final Batch<T> batch;
    private final Function<? super T, ? extends V> function;

    public CollectListBatch(Batch<T> batch, Function<? super T, ? extends V> function) {
        this.batch = batch;
        this.function = function;
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.batch.forEach(Functions.bind(procedure, this.function));
    }

    @Override
    public ListBatch<V> select(Predicate<? super V> predicate) {
        return new SelectListBatch<V>(this, predicate);
    }

    @Override
    public <VV> ListBatch<VV> collect(Function<? super V, ? extends VV> function) {
        return new CollectListBatch<V, VV>(this, function);
    }

    @Override
    public <VV> ListBatch<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return new FlatCollectListBatch(this, function);
    }

    @Override
    public UnsortedSetBatch<V> distinct(ConcurrentHashMap<V, Boolean> distinct) {
        return new DistinctBatch<V>(this, distinct);
    }
}

