/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list;

import shadow.palantir.driver.org.eclipse.collections.api.annotation.Beta;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.list.ListIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.AbstractBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.CollectListBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.DistinctBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.FlatCollectListBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.ListBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.RootListBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.SelectListBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;

@Beta
public class ListIterableBatch<T>
extends AbstractBatch<T>
implements RootListBatch<T> {
    private final ListIterable<T> list;
    private final int chunkStartIndex;
    private final int chunkEndIndex;

    public ListIterableBatch(ListIterable<T> list, int chunkStartIndex, int chunkEndIndex) {
        this.list = list;
        this.chunkStartIndex = chunkStartIndex;
        this.chunkEndIndex = chunkEndIndex;
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
            procedure.value(this.list.get(i));
        }
    }

    @Override
    public int count(Predicate<? super T> predicate) {
        int count = 0;
        for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
            if (!predicate.accept(this.list.get(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
            if (!predicate.accept(this.list.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
            if (predicate.accept(this.list.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
            if (!predicate.accept(this.list.get(i))) continue;
            return this.list.get(i);
        }
        return null;
    }

    @Override
    public ListBatch<T> select(Predicate<? super T> predicate) {
        return new SelectListBatch<T>(this, predicate);
    }

    @Override
    public <V> ListBatch<V> collect(Function<? super T, ? extends V> function) {
        return new CollectListBatch<T, V>(this, function);
    }

    @Override
    public <V> ListBatch<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new FlatCollectListBatch(this, function);
    }

    @Override
    public UnsortedSetBatch<T> distinct(ConcurrentHashMap<T, Boolean> distinct) {
        return new DistinctBatch<T>(this, distinct);
    }
}

