/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIterable;
import shadow.palantir.driver.org.eclipse.collections.api.annotation.Beta;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.OrderedBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.ListBatch;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.Iterate;

@Beta
public class ParallelFlatCollectListIterable<T, V>
extends AbstractParallelListIterable<V, ListBatch<V>> {
    private final AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable;
    private final Function<? super T, ? extends Iterable<V>> function;

    public ParallelFlatCollectListIterable(AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable, Function<? super T, ? extends Iterable<V>> function) {
        this.parallelIterable = parallelIterable;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<ListBatch<V>> split() {
        return this.parallelIterable.split().collect((T batch) -> batch.flatCollect(this.function));
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.parallelIterable.forEach((? super T each) -> Iterate.forEach(this.function.valueOf(each), procedure));
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        AtomicReference result = new AtomicReference();
        this.parallelIterable.anySatisfy((? super T each) -> Iterate.anySatisfy(this.function.valueOf(each), (? super T each1) -> {
            if (predicate.accept((Object)each1)) {
                result.compareAndSet(null, each1);
                return true;
            }
            return false;
        }));
        return result.get();
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.anySatisfy((? super T each) -> Iterate.anySatisfy(this.function.valueOf(each), predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.allSatisfy((? super T each) -> Iterate.allSatisfy(this.function.valueOf(each), predicate));
    }
}

