/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.set;

import java.util.concurrent.ExecutorService;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIterable;
import shadow.palantir.driver.org.eclipse.collections.api.annotation.Beta;
import shadow.palantir.driver.org.eclipse.collections.api.bag.UnsortedBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.map.MapIterable;
import shadow.palantir.driver.org.eclipse.collections.api.multimap.bag.UnsortedBagMultimap;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.Functions;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.Predicates;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterableImpl;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.Batch;

@Beta
public class ParallelCollectIterable<T, V>
extends AbstractParallelIterableImpl<V, Batch<V>> {
    private final AbstractParallelIterable<T, ? extends Batch<T>> delegate;
    private final Function<? super T, ? extends V> function;

    public ParallelCollectIterable(AbstractParallelIterable<T, ? extends Batch<T>> delegate, Function<? super T, ? extends V> function) {
        this.delegate = delegate;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.delegate.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public LazyIterable<Batch<V>> split() {
        return this.delegate.split().collect((T eachBatch) -> eachBatch.collect(this.function));
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.delegate.forEach(Functions.bind(procedure, this.function));
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.delegate.anySatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.delegate.allSatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        T resultItem = this.delegate.detect(Predicates.attributePredicate(this.function, predicate));
        return resultItem == null ? null : (V)this.function.valueOf((T)resultItem);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toList().collect((Function)this.function).toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toList().collect((Function)this.function).toArray((T[])array);
    }

    @Override
    public <V1> UnsortedBagMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        UnsortedBag mutableBag = this.delegate.toBag().collect((Function)this.function);
        return mutableBag.groupBy(function);
    }

    @Override
    public <V1> UnsortedBagMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        UnsortedBag mutableBag = this.delegate.toBag().collect((Function)this.function);
        return mutableBag.groupByEach(function);
    }

    @Override
    public <V1> MapIterable<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> function) {
        UnsortedBag mutableBag = this.delegate.toBag().collect((Function)this.function);
        return mutableBag.groupByUniqueKey(function);
    }
}

