/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import shadow.palantir.driver.org.eclipse.collections.api.FloatIterable;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function0;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.FloatLists;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.FloatIterator;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.internal.IterableIterate;

public class ChunkFloatIterable
extends AbstractLazyIterable<FloatIterable> {
    private final FloatIterable adapted;
    private final int size;

    public ChunkFloatIterable(FloatIterable delegate, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.adapted = delegate;
        this.size = size;
    }

    @Override
    public Iterator<FloatIterable> iterator() {
        return new ChunkFloatIterator(this.adapted, this.size);
    }

    @Override
    public void each(Procedure<? super FloatIterable> procedure) {
        IterableIterate.forEach(this, procedure);
    }

    public static class ChunkFloatIterator
    implements Iterator<FloatIterable> {
        private final FloatIterator iterator;
        private final int size;
        private final Function0<MutableFloatCollection> speciesNewStrategy;

        public ChunkFloatIterator(FloatIterable iterable, int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            this.size = size;
            this.iterator = iterable.floatIterator();
            this.speciesNewStrategy = iterable instanceof MutableFloatCollection ? ((MutableFloatCollection)iterable)::newEmpty : FloatLists.mutable::empty;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public FloatIterable next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MutableFloatCollection result = this.speciesNewStrategy.value();
            for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
                result.add(this.iterator.next());
            }
            return result;
        }
    }
}

