/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive;

import java.util.Arrays;
import java.util.Iterator;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIterable;
import shadow.palantir.driver.org.eclipse.collections.api.ShortIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableShortBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ShortFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure2;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortSets;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.ShortIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableShortList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableShortSet;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;

public class CollectShortIterable<T>
extends AbstractLazyShortIterable {
    private final LazyIterable<T> iterable;
    private final ShortFunction<? super T> function;
    private final ShortFunctionToProcedure<T> shortFunctionToProcedure;

    public CollectShortIterable(LazyIterable<T> adapted, ShortFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.shortFunctionToProcedure = new ShortFunctionToProcedure(function);
    }

    @Override
    public ShortIterator shortIterator() {
        return new ShortIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectShortIterable.this.iterable.iterator();
            }

            @Override
            public short next() {
                return CollectShortIterable.this.function.shortValueOf(this.iterator.next());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.iterable.forEachWith(this.shortFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.iterable.count((? super T each) -> predicate.accept(this.function.shortValueOf(each)));
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.iterable.anySatisfy((? super T each) -> predicate.accept(this.function.shortValueOf(each)));
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.iterable.allSatisfy((? super T each) -> predicate.accept(this.function.shortValueOf(each)));
    }

    @Override
    public short[] toArray() {
        short[] array = new short[this.size()];
        this.iterable.forEachWithIndex((each, index) -> {
            array[index] = this.function.shortValueOf(each);
        });
        return array;
    }

    @Override
    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableShortList toList() {
        return ShortLists.mutable.withAll(this);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortSets.mutable.withAll(this);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortBags.mutable.withAll(this);
    }

    @Override
    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class ShortFunctionToProcedure<T>
    implements Procedure2<T, ShortProcedure> {
        private static final long serialVersionUID = 1L;
        private final ShortFunction<? super T> function;

        private ShortFunctionToProcedure(ShortFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each, ShortProcedure procedure) {
            procedure.value(this.function.shortValueOf(each));
        }
    }
}

