/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import shadow.palantir.driver.org.eclipse.collections.api.DoubleIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyDoubleIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.DoubleBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.DoubleLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.DoubleSets;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.DoubleIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.DoubleList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableDoubleList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;

public class ReverseDoubleIterable
extends AbstractLazyDoubleIterable {
    private final DoubleList adapted;

    public ReverseDoubleIterable(DoubleList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseDoubleIterable adapt(DoubleList doubleList) {
        return new ReverseDoubleIterable(doubleList);
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new ReverseDoubleIterator();
    }

    @Override
    public void each(DoubleProcedure procedure) {
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    @Override
    public double sum() {
        return this.adapted.sum();
    }

    @Override
    public double max() {
        return this.adapted.max();
    }

    @Override
    public double min() {
        return this.adapted.min();
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    @Override
    public double average() {
        return this.adapted.average();
    }

    @Override
    public double median() {
        return this.adapted.median();
    }

    @Override
    public double[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    @Override
    public double[] toArray() {
        double[] results = new double[this.adapted.size()];
        int index = 0;
        DoubleIterator iterator = this.doubleIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    @Override
    public boolean contains(double value) {
        return this.adapted.contains(value);
    }

    @Override
    public boolean containsAll(double ... source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public int size() {
        return this.adapted.size();
    }

    @Override
    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleLists.mutable.withAll(this);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleSets.mutable.withAll(this);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleBags.mutable.withAll(this);
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    private class ReverseDoubleIterator
    implements DoubleIterator {
        private int currentIndex;

        private ReverseDoubleIterator() {
            this.currentIndex = ReverseDoubleIterable.this.adapted.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        @Override
        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            double next = ReverseDoubleIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

