/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import shadow.palantir.driver.org.eclipse.collections.api.CharIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableCharBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.CharBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.CharLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.CharSets;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.CharIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableCharList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableCharSet;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;

public class SelectCharIterable
extends AbstractLazyCharIterable {
    private final CharIterable delegate;
    private final CharPredicate predicate;

    public SelectCharIterable(CharIterable delegate, CharPredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public CharIterator charIterator() {
        return new SelectCharIterator(this.delegate, this.predicate);
    }

    @Override
    public void each(CharProcedure procedure) {
        this.delegate.forEach(new IfCharProcedure(procedure));
    }

    @Override
    public int size() {
        return this.delegate.count(this.predicate);
    }

    @Override
    public boolean isEmpty() {
        return !this.charIterator().hasNext();
    }

    @Override
    public boolean notEmpty() {
        return this.charIterator().hasNext();
    }

    @Override
    public int count(CharPredicate predicate) {
        CountCharProcedure countCharProcedure = new CountCharProcedure(predicate);
        this.forEach(countCharProcedure);
        return countCharProcedure.getCount();
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(each -> this.predicate.accept(each) && predicate.accept(each));
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.noneSatisfy(each -> !predicate.accept(each));
    }

    @Override
    public char[] toArray() {
        final char[] array = new char[this.size()];
        this.forEach(new CharProcedure(){
            private int index = 0;

            @Override
            public void value(char each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    @Override
    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableCharList toList() {
        return CharLists.mutable.withAll(this);
    }

    @Override
    public MutableCharSet toSet() {
        return CharSets.mutable.withAll(this);
    }

    @Override
    public MutableCharBag toBag() {
        return CharBags.mutable.withAll(this);
    }

    private static final class SelectCharIterator
    implements CharIterator {
        private final CharIterator iterator;
        private final CharPredicate predicate;
        private char next;
        private boolean verifiedHasNext = false;

        private SelectCharIterator(CharIterable iterable, CharPredicate predicate) {
            this(iterable.charIterator(), predicate);
        }

        private SelectCharIterator(CharIterator iterator, CharPredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                char temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        @Override
        public char next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfCharProcedure
    implements CharProcedure {
        private static final long serialVersionUID = 1L;
        private final CharProcedure procedure;

        private IfCharProcedure(CharProcedure procedure) {
            this.procedure = procedure;
        }

        @Override
        public void value(char each) {
            if (SelectCharIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountCharProcedure
    implements CharProcedure {
        private static final long serialVersionUID = 1L;
        private final CharPredicate predicate;
        private int counter = 0;

        private CountCharProcedure(CharPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public void value(char each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

