/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.CharIterable;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.CharIterator;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;

public class TapCharIterable
extends AbstractLazyCharIterable {
    private final CharIterable adapted;
    private final CharProcedure procedure;

    public TapCharIterable(CharIterable delegate, CharProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    @Override
    public void each(CharProcedure procedure) {
        this.adapted.forEach(each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.adapted.anySatisfy(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.adapted.allSatisfy(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.adapted.noneSatisfy(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.adapted.detectIfNone(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        }, ifNone);
    }

    @Override
    public CharIterator charIterator() {
        return new TapCharIterator(this.adapted, this.procedure);
    }

    public static class TapCharIterator
    implements CharIterator {
        private final CharIterator iterator;
        private final CharProcedure procedure;

        public TapCharIterator(CharIterable iterable, CharProcedure procedure) {
            this(iterable.charIterator(), procedure);
        }

        public TapCharIterator(CharIterator iterator, CharProcedure procedure) {
            this.iterator = iterator;
            this.procedure = procedure;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public char next() {
            char next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

