/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.list.fixed;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.Spliterators;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.list.FixedSizeList;
import shadow.palantir.driver.org.eclipse.collections.api.list.MutableList;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.Predicates2;
import shadow.palantir.driver.org.eclipse.collections.impl.list.fixed.AbstractArrayAdapter;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.Iterate;

public final class ArrayAdapter<T>
extends AbstractArrayAdapter<T>
implements Serializable,
FixedSizeList<T> {
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private ArrayAdapter(T[] newElements) {
        super(newElements);
    }

    public static <E> ArrayAdapter<E> adapt(E ... array) {
        return new ArrayAdapter<E>(array);
    }

    public static <E> ArrayAdapter<E> newArray() {
        return ArrayAdapter.newArrayWith(EMPTY_ARRAY);
    }

    public static <E> ArrayAdapter<E> newArray(Iterable<? extends E> source) {
        return new ArrayAdapter<Object>(Iterate.toArray(source));
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.items, 16);
    }

    public static <E> ArrayAdapter<E> newArrayWithItem(Iterable<? extends E> iterable, E itemToAdd) {
        int oldSize = Iterate.sizeOf(iterable);
        Object[] array = new Object[oldSize + 1];
        Iterate.toArray(iterable, array);
        array[oldSize] = itemToAdd;
        return new ArrayAdapter<Object>(array);
    }

    public static <E> ArrayAdapter<E> newArrayWith(E one) {
        return new ArrayAdapter<Object>(new Object[]{one});
    }

    public static <E> ArrayAdapter<E> newArrayWith(E one, E two) {
        return new ArrayAdapter<Object>(new Object[]{one, two});
    }

    public static <E> ArrayAdapter<E> newArrayWith(E one, E two, E three) {
        return new ArrayAdapter<Object>(new Object[]{one, two, three});
    }

    public static <E> ArrayAdapter<E> newArrayWith(E one, E two, E three, E four) {
        return new ArrayAdapter<Object>(new Object[]{one, two, three, four});
    }

    public static <E> ArrayAdapter<E> newArrayWith(E one, E two, E three, E four, E five) {
        return new ArrayAdapter<Object>(new Object[]{one, two, three, four, five});
    }

    public static <E> ArrayAdapter<E> newArrayWith(E one, E two, E three, E four, E five, E six) {
        return new ArrayAdapter<Object>(new Object[]{one, two, three, four, five, six});
    }

    public static <E> ArrayAdapter<E> newArrayWith(E one, E two, E three, E four, E five, E six, E seven) {
        return new ArrayAdapter<Object>(new Object[]{one, two, three, four, five, six, seven});
    }

    public static <E> ArrayAdapter<E> newArrayWith(E ... elements) {
        return new ArrayAdapter<Object>((Object[])elements.clone());
    }

    @Override
    public T set(int index, T element) {
        Object oldValue = this.items[index];
        this.items[index] = element;
        return (T)oldValue;
    }

    @Override
    public ArrayAdapter<T> with(T value) {
        return ArrayAdapter.newArrayWithItem(this, value);
    }

    @Override
    public ArrayAdapter<T> without(T element) {
        if (this.contains(element)) {
            return ArrayAdapter.newArray(this.toList().without((Object)element));
        }
        return this;
    }

    @Override
    public ArrayAdapter<T> withAll(Iterable<? extends T> elements) {
        if (Iterate.isEmpty(elements)) {
            return this;
        }
        return ArrayAdapter.newArray(this.toList().withAll((Iterable)elements));
    }

    @Override
    public ArrayAdapter<T> withoutAll(Iterable<? extends T> elements) {
        if (Iterate.isEmpty(elements)) {
            return this;
        }
        if (Iterate.anySatisfyWith(elements, Predicates2.in(), this)) {
            return ArrayAdapter.newArray(this.toList().withoutAll((Iterable)elements));
        }
        return this;
    }

    @Override
    public ArrayAdapter<T> clone() {
        return new ArrayAdapter<Object>((Object[])this.items.clone());
    }

    @Override
    public ArrayAdapter<T> sortThis(Comparator<? super T> comparator) {
        return (ArrayAdapter)super.sortThis(comparator);
    }

    @Override
    public FixedSizeList<T> tap(Procedure<? super T> procedure) {
        this.each(procedure);
        return this;
    }

    @Override
    public FixedSizeList<T> toReversed() {
        MutableList result = this.clone();
        result.reverseThis();
        return result;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] localItems = this.items;
        int size = localItems.length;
        objectOutputStream.writeInt(size);
        for (int i = 0; i < size; ++i) {
            objectOutputStream.writeObject(localItems[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int arrayLength = objectInputStream.readInt();
        Object[] localItems = this.items = new Object[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            localItems[i] = objectInputStream.readObject();
        }
    }
}

