/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.list.mutable;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import shadow.palantir.driver.org.eclipse.collections.api.block.HashingStrategy;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function2;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.IntFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.LongFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ShortFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate2;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.list.MutableList;
import shadow.palantir.driver.org.eclipse.collections.api.list.ParallelListIterable;
import shadow.palantir.driver.org.eclipse.collections.api.multimap.list.MutableListMultimap;
import shadow.palantir.driver.org.eclipse.collections.api.partition.list.PartitionMutableList;
import shadow.palantir.driver.org.eclipse.collections.api.stack.MutableStack;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.Pair;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.Functions;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.HashingStrategies;
import shadow.palantir.driver.org.eclipse.collections.impl.collection.mutable.AbstractCollectionAdapter;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.ReverseIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.parallel.list.ListIterableParallelIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.ListAdapter;
import shadow.palantir.driver.org.eclipse.collections.impl.stack.mutable.ArrayStack;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.ListIterate;

public abstract class AbstractListAdapter<T>
extends AbstractCollectionAdapter<T>
implements MutableList<T> {
    @Override
    public MutableList<T> clone() {
        try {
            return (MutableList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected abstract List<T> getDelegate();

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        return this.getDelegate().addAll(index, collection);
    }

    @Override
    public T get(int index) {
        return (T)this.getDelegate().get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.getDelegate().set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.getDelegate().add(index, element);
    }

    @Override
    public T remove(int index) {
        return (T)this.getDelegate().remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getDelegate().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.getDelegate().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.getDelegate().listIterator(index);
    }

    @Override
    public <V> MutableList<T> distinctBy(Function<? super T, ? extends V> function) {
        return this.distinct((HashingStrategy)HashingStrategies.fromFunction(function));
    }

    @Override
    public MutableList<T> sortThisByInt(IntFunction<? super T> function) {
        return this.sortThis(Functions.toIntComparator(function));
    }

    @Override
    public MutableList<T> sortThisByBoolean(BooleanFunction<? super T> function) {
        return this.sortThis(Functions.toBooleanComparator(function));
    }

    @Override
    public MutableList<T> sortThisByChar(CharFunction<? super T> function) {
        return this.sortThis(Functions.toCharComparator(function));
    }

    @Override
    public MutableList<T> sortThisByByte(ByteFunction<? super T> function) {
        return this.sortThis(Functions.toByteComparator(function));
    }

    @Override
    public MutableList<T> sortThisByShort(ShortFunction<? super T> function) {
        return this.sortThis(Functions.toShortComparator(function));
    }

    @Override
    public MutableList<T> sortThisByFloat(FloatFunction<? super T> function) {
        return this.sortThis(Functions.toFloatComparator(function));
    }

    @Override
    public MutableList<T> sortThisByLong(LongFunction<? super T> function) {
        return this.sortThis(Functions.toLongComparator(function));
    }

    @Override
    public MutableList<T> sortThisByDouble(DoubleFunction<? super T> function) {
        return this.sortThis(Functions.toDoubleComparator(function));
    }

    @Override
    public MutableList<T> subList(int fromIndex, int toIndex) {
        return ListAdapter.adapt(this.getDelegate().subList(fromIndex, toIndex));
    }

    @Override
    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public MutableStack<T> toStack() {
        return ArrayStack.newStack(this.getDelegate());
    }

    @Override
    public ReverseIterable<T> asReversed() {
        return ReverseIterable.adapt(this);
    }

    @Override
    public ParallelListIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return new ListIterableParallelIterable(this, executorService, batchSize);
    }

    @Override
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return ListIterate.groupBy(this.getDelegate(), function);
    }

    @Override
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return ListIterate.groupByEach(this.getDelegate(), function);
    }

    @Override
    public MutableList<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public MutableList<T> select(Predicate<? super T> predicate) {
        return ListIterate.select(this.getDelegate(), predicate);
    }

    @Override
    public MutableList<T> reject(Predicate<? super T> predicate) {
        return ListIterate.reject(this.getDelegate(), predicate);
    }

    @Override
    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        return ListIterate.selectInstancesOf(this.getDelegate(), clazz);
    }

    @Override
    public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
        return ListIterate.collect(this.getDelegate(), function);
    }

    @Override
    public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return ListIterate.flatCollect(this.getDelegate(), function);
    }

    @Override
    public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return ListIterate.collectIf(this.getDelegate(), predicate, function);
    }

    @Override
    public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
        return ListIterate.partition(this.getDelegate(), predicate);
    }

    @Override
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ListIterate.partitionWith(this.getDelegate(), predicate, parameter);
    }

    @Override
    public <P> MutableList<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ListIterate.selectWith(this.getDelegate(), predicate, parameter);
    }

    @Override
    public <P> MutableList<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ListIterate.rejectWith(this.getDelegate(), predicate, parameter);
    }

    @Override
    public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return ListIterate.collectWith(this.getDelegate(), function, parameter);
    }

    @Override
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
        return ListIterate.zip(this.getDelegate(), that);
    }

    @Override
    public MutableList<Pair<T, Integer>> zipWithIndex() {
        return ListIterate.zipWithIndex(this.getDelegate());
    }
}

