/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.CharIterable;
import shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableCharListFactory;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableCharList;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.CharLists;
import shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.Iterate;

public class MutableCharListFactoryImpl
implements MutableCharListFactory {
    public static final MutableCharListFactory INSTANCE = new MutableCharListFactoryImpl();

    @Override
    public MutableCharList empty() {
        return new CharArrayList();
    }

    @Override
    public MutableCharList of() {
        return this.empty();
    }

    @Override
    public MutableCharList with() {
        return this.empty();
    }

    @Override
    public MutableCharList withInitialCapacity(int capacity) {
        return new CharArrayList(capacity);
    }

    @Override
    public MutableCharList of(char ... items) {
        return this.with(items);
    }

    @Override
    public MutableCharList with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return CharArrayList.newListWith(items);
    }

    @Override
    public MutableCharList ofAll(CharIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableCharList withAll(CharIterable items) {
        return CharArrayList.newList(items);
    }

    @Override
    public MutableCharList ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableCharList withAll(Iterable<Character> iterable) {
        return Iterate.collectChar(iterable, Character::charValue, CharLists.mutable.empty());
    }
}

