/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive;

import java.util.stream.LongStream;
import shadow.palantir.driver.org.eclipse.collections.api.LongIterable;
import shadow.palantir.driver.org.eclipse.collections.api.factory.list.primitive.MutableLongListFactory;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableLongList;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.LongLists;
import shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.Iterate;

public class MutableLongListFactoryImpl
implements MutableLongListFactory {
    public static final MutableLongListFactory INSTANCE = new MutableLongListFactoryImpl();

    @Override
    public MutableLongList empty() {
        return new LongArrayList();
    }

    @Override
    public MutableLongList of() {
        return this.empty();
    }

    @Override
    public MutableLongList with() {
        return this.empty();
    }

    @Override
    public MutableLongList withInitialCapacity(int capacity) {
        return new LongArrayList(capacity);
    }

    @Override
    public MutableLongList of(long ... items) {
        return this.with(items);
    }

    @Override
    public MutableLongList with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return LongArrayList.newListWith(items);
    }

    @Override
    public MutableLongList ofAll(LongIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableLongList withAll(LongIterable items) {
        return LongArrayList.newList(items);
    }

    @Override
    public MutableLongList ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableLongList withAll(Iterable<Long> iterable) {
        return Iterate.collectLong(iterable, Long::longValue, LongLists.mutable.empty());
    }

    @Override
    public MutableLongList ofAll(LongStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableLongList withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

