/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.map.fixed;

import java.util.Objects;
import shadow.palantir.driver.org.eclipse.collections.api.factory.map.FixedSizeMapFactory;
import shadow.palantir.driver.org.eclipse.collections.api.map.FixedSizeMap;
import shadow.palantir.driver.org.eclipse.collections.impl.map.fixed.DoubletonMap;
import shadow.palantir.driver.org.eclipse.collections.impl.map.fixed.EmptyMap;
import shadow.palantir.driver.org.eclipse.collections.impl.map.fixed.SingletonMap;
import shadow.palantir.driver.org.eclipse.collections.impl.map.fixed.TripletonMap;

public class FixedSizeMapFactoryImpl
implements FixedSizeMapFactory {
    public static final FixedSizeMapFactory INSTANCE = new FixedSizeMapFactoryImpl();
    private static final FixedSizeMap<?, ?> EMPTY_MAP = new EmptyMap();

    @Override
    public <K, V> FixedSizeMap<K, V> empty() {
        return EMPTY_MAP;
    }

    @Override
    public <K, V> FixedSizeMap<K, V> of() {
        return this.empty();
    }

    @Override
    public <K, V> FixedSizeMap<K, V> with() {
        return this.empty();
    }

    @Override
    public <K, V> FixedSizeMap<K, V> of(K key, V value) {
        return this.with(key, value);
    }

    @Override
    public <K, V> FixedSizeMap<K, V> with(K key, V value) {
        return new SingletonMap<K, V>(key, value);
    }

    @Override
    public <K, V> FixedSizeMap<K, V> of(K key1, V value1, K key2, V value2) {
        return this.with(key1, value1, key2, value2);
    }

    @Override
    public <K, V> FixedSizeMap<K, V> with(K key1, V value1, K key2, V value2) {
        if (Objects.equals(key1, key2)) {
            return this.of(key1, value2);
        }
        return new DoubletonMap<K, V>(key1, value1, key2, value2);
    }

    @Override
    public <K, V> FixedSizeMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        return this.with(key1, value1, key2, value2, key3, value3);
    }

    @Override
    public <K, V> FixedSizeMap<K, V> with(K key1, V value1, K key2, V value2, K key3, V value3) {
        if (Objects.equals(key1, key2) && Objects.equals(key2, key3)) {
            return this.of(key1, value3);
        }
        if (Objects.equals(key1, key2)) {
            return this.of(key1, value2, key3, value3);
        }
        if (Objects.equals(key1, key3)) {
            return this.of(key2, value2, key1, value3);
        }
        if (Objects.equals(key2, key3)) {
            return this.of(key1, value1, key2, value3);
        }
        return new TripletonMap<K, V>(key1, value1, key2, value2, key3, value3);
    }
}

