/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import shadow.palantir.driver.org.eclipse.collections.api.ByteIterable;
import shadow.palantir.driver.org.eclipse.collections.api.IntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyByteIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.ImmutableBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableByteBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.IntBytePredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.IntByteProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.ByteIterator;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.IntIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.MutableList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableByteList;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.ImmutableByteIntMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.ImmutableIntByteMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.IntByteMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.MutableByteIntMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.MutableIntByteMap;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableByteSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableIntSet;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.primitive.IntBytePair;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntByteProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.Lists;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.ByteBags;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.ByteIntMaps;
import shadow.palantir.driver.org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.IntByteHashMap;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

final class ImmutableIntByteHashMap
implements ImmutableIntByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntByteMap delegate;

    ImmutableIntByteHashMap(IntByteMap delegate) {
        this.delegate = new IntByteHashMap(delegate);
    }

    @Override
    public byte get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public byte getIfAbsent(int key, byte ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public byte getOrThrow(int key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(byte value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(ByteProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(IntByteProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyIntIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<IntBytePair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableByteIntMap flipUniqueValues() {
        MutableByteIntMap result = ByteIntMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    @Override
    public ImmutableIntByteMap select(IntBytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntByteMap reject(IntBytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            ByteIterator iterator = this.delegate.byteIterator();
            while (iterator.hasNext()) {
                MutableByteBag batch = ByteBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add(batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableIntByteMap toImmutable() {
        return this;
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(this.delegate.byteIterator());
    }

    @Override
    public void each(ByteProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(BytePredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableByteBag select(BytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableByteBag reject(BytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        RichIterable bag = this.delegate.collect((ByteToObjectFunction)function);
        return bag.toImmutable();
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public byte max() {
        return this.delegate.max();
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public byte min() {
        return this.delegate.min();
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableByteList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public byte[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public byte[] toArray(byte[] target) {
        return this.delegate.toArray(target);
    }

    @Override
    public boolean contains(byte value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(byte ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableByteList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableByteSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableByteBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyByteIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableIntByteMap newWithKeyValue(int key, byte value) {
        IntByteHashMap map = new IntByteHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableIntByteMap newWithoutKey(int key) {
        IntByteHashMap map = new IntByteHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableIntByteMap newWithoutAllKeys(IntIterable keys) {
        IntByteHashMap map = new IntByteHashMap(this.size());
        map.putAll(this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    @Override
    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableIntByteMapSerializationProxy(this);
    }

    protected static class ImmutableIntByteMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntByteMap map;

        public ImmutableIntByteMapSerializationProxy() {
        }

        protected ImmutableIntByteMapSerializationProxy(IntByteMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedIntByteProcedure(){

                    @Override
                    public void safeValue(int key, byte value) throws IOException {
                        out.writeInt(key);
                        out.writeByte(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntByteHashMap deserializedMap = new IntByteHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readInt(), in.readByte());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

