/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import shadow.palantir.driver.org.eclipse.collections.api.CharIterable;
import shadow.palantir.driver.org.eclipse.collections.api.IntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyCharIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.ImmutableBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableCharBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.IntCharPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.IntCharProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.CharIterator;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.IntIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.MutableList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableCharList;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.ImmutableCharIntMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.ImmutableIntCharMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.IntCharMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.MutableCharIntMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.MutableIntCharMap;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableCharSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableIntSet;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.primitive.IntCharPair;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntCharProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.Lists;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.CharBags;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.CharIntMaps;
import shadow.palantir.driver.org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.IntCharHashMap;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

final class ImmutableIntCharHashMap
implements ImmutableIntCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntCharMap delegate;

    ImmutableIntCharHashMap(IntCharMap delegate) {
        this.delegate = new IntCharHashMap(delegate);
    }

    @Override
    public char get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public char getIfAbsent(int key, char ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public char getOrThrow(int key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(char value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(CharProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(IntCharProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyIntIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<IntCharPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableCharIntMap flipUniqueValues() {
        MutableCharIntMap result = CharIntMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    @Override
    public ImmutableIntCharMap select(IntCharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntCharMap reject(IntCharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            CharIterator iterator = this.delegate.charIterator();
            while (iterator.hasNext()) {
                MutableCharBag batch = CharBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add(batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableIntCharMap toImmutable() {
        return this;
    }

    @Override
    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(this.delegate.charIterator());
    }

    @Override
    public void each(CharProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(CharPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableCharBag select(CharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableCharBag reject(CharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        RichIterable bag = this.delegate.collect((CharToObjectFunction)function);
        return bag.toImmutable();
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public char max() {
        return this.delegate.max();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public char min() {
        return this.delegate.min();
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableCharList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public char[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public char[] toArray(char[] target) {
        return this.delegate.toArray(target);
    }

    @Override
    public boolean contains(char value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableCharList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableCharSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableCharBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyCharIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableIntCharMap newWithKeyValue(int key, char value) {
        IntCharHashMap map = new IntCharHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableIntCharMap newWithoutKey(int key) {
        IntCharHashMap map = new IntCharHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableIntCharMap newWithoutAllKeys(IntIterable keys) {
        IntCharHashMap map = new IntCharHashMap(this.size());
        map.putAll(this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    @Override
    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableIntCharMapSerializationProxy(this);
    }

    protected static class ImmutableIntCharMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntCharMap map;

        public ImmutableIntCharMapSerializationProxy() {
        }

        protected ImmutableIntCharMapSerializationProxy(IntCharMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedIntCharProcedure(){

                    @Override
                    public void safeValue(int key, char value) throws IOException {
                        out.writeInt(key);
                        out.writeChar(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntCharHashMap deserializedMap = new IntCharHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readInt(), in.readChar());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

