/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.map.mutable;

import java.util.Iterator;
import java.util.Optional;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.MutableBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function0;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function2;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.FloatFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.IntFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.LongFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate2;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Bags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Maps;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ObjectDoubleMaps;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ObjectLongMaps;
import shadow.palantir.driver.org.eclipse.collections.api.map.MutableMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.MutableMapIterable;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.Pair;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import shadow.palantir.driver.org.eclipse.collections.impl.map.AbstractMapIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.UnifiedMap;
import shadow.palantir.driver.org.eclipse.collections.impl.tuple.AbstractImmutableEntry;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.LazyIterate;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.MapIterate;

public abstract class AbstractMutableMapIterable<K, V>
extends AbstractMapIterable<K, V>
implements MutableMapIterable<K, V> {
    @Override
    public Iterator<V> iterator() {
        return this.values().iterator();
    }

    @Override
    public V getIfAbsentPut(K key, Function0<? extends V> function) {
        Object result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = function.value();
            this.put(key, result);
        }
        return result;
    }

    @Override
    public V getIfAbsentPut(K key, V value) {
        Object result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = value;
            this.put(key, result);
        }
        return result;
    }

    @Override
    public V getIfAbsentPutWithKey(K key, Function<? super K, ? extends V> function) {
        return this.getIfAbsentPutWith(key, function, key);
    }

    @Override
    public <P> V getIfAbsentPutWith(K key, Function<? super P, ? extends V> function, P parameter) {
        Object result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = function.valueOf(parameter);
            this.put(key, result);
        }
        return result;
    }

    @Override
    public V updateValue(K key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        V oldValue = this.getIfAbsent(key, factory);
        V newValue = function.valueOf(oldValue);
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public <P> V updateValueWith(K key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        V oldValue = this.getIfAbsent(key, factory);
        V newValue = function.value(oldValue, parameter);
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public <VV> MutableMapIterable<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap(this.size()));
    }

    @Override
    public <K1, V1, V2> MutableMap<K1, V2> aggregateBy(Function<? super K, ? extends K1> keyFunction, Function<? super V, ? extends V1> valueFunction, Function0<? extends V2> zeroValueFactory, Function2<? super V2, ? super V1, ? extends V2> nonMutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEachKeyValue((key, value) -> map.updateValueWith(keyFunction.valueOf((Object)key), zeroValueFactory, nonMutatingAggregator, valueFunction.valueOf((Object)value)));
        return map;
    }

    @Override
    public RichIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    @Override
    public RichIterable<V> valuesView() {
        return LazyIterate.adapt(this.values());
    }

    @Override
    public RichIterable<Pair<K, V>> keyValuesView() {
        return LazyIterate.adapt(this.entrySet()).collect(AbstractImmutableEntry.getPairFunction());
    }

    @Override
    public <K2, V2> MutableMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return MapIterate.collect(this, function, UnifiedMap.newMap(this.size()));
    }

    @Override
    public MutableMap<V, K> flipUniqueValues() {
        return MapIterate.flipUniqueValues(this);
    }

    @Override
    public Pair<K, V> detect(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.detect(this, predicate);
    }

    @Override
    public Optional<Pair<K, V>> detectOptional(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.detectOptional(this, predicate);
    }

    @Override
    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    @Override
    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    @Override
    public <V1> MutableBag<V1> countBy(Function<? super V, ? extends V1> function) {
        return this.collect(function, Bags.mutable.empty());
    }

    @Override
    public <V1, P> MutableBag<V1> countByWith(Function2<? super V, ? super P, ? extends V1> function, P parameter) {
        return this.collectWith(function, parameter, Bags.mutable.empty());
    }

    @Override
    public <V1> MutableBag<V1> countByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.flatCollect(function, Bags.mutable.empty());
    }
}

