/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import shadow.palantir.driver.org.eclipse.collections.api.ByteIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyByteIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIterable;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableByteBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.ByteIterator;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.MutableByteIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.MutableList;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableByteList;
import shadow.palantir.driver.org.eclipse.collections.api.set.MutableSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ByteSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableByteSet;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import shadow.palantir.driver.org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.Lists;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.Sets;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.ByteSets;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import shadow.palantir.driver.org.eclipse.collections.impl.map.mutable.primitive.MutableByteKeysMap;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.SynchronizedByteSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

public abstract class AbstractMutableByteKeySet
implements MutableByteSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !AbstractMutableByteKeySet.isEmptyKey(key) && !AbstractMutableByteKeySet.isRemovedKey(key);
    }

    protected abstract byte getKeyAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract MutableByteKeysMap getOuter();

    protected abstract AbstractSentinelValues getSentinelValues();

    @Override
    public void each(ByteProcedure procedure) {
        this.getOuter().forEachKey(procedure);
    }

    @Override
    public int count(BytePredicate predicate) {
        int count = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept((byte)0)) {
                ++count;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept((byte)1)) {
                ++count;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept((byte)0)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept((byte)1)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept((byte)0)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept((byte)1)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(byte element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(byte ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(ByteIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableByteSet select(BytePredicate predicate) {
        ByteHashSet result = new ByteHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept((byte)0)) {
                result.add((byte)0);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept((byte)1)) {
                result.add((byte)1);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableByteSet reject(BytePredicate predicate) {
        ByteHashSet result = new ByteHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept((byte)0)) {
                result.add((byte)0);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept((byte)1)) {
                result.add((byte)1);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableByteSet with(byte element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableByteSet without(byte element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableByteSet withAll(ByteIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableByteSet withoutAll(ByteIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
        MutableSet result = Sets.mutable.with();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result.add(function.valueOf((byte)0));
            }
            if (this.getSentinelValues().containsOneKey) {
                result.add(function.valueOf((byte)1));
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result.add(function.valueOf(this.getKeyAtIndex(i)));
        }
        return result;
    }

    @Override
    public boolean remove(byte key) {
        int oldSize = this.getOuter().size();
        this.getOuter().removeKey(key);
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(ByteIterable source) {
        int oldSize = this.getOuter().size();
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            this.getOuter().removeKey(iterator.next());
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(byte ... source) {
        int oldSize = this.getOuter().size();
        for (byte item : source) {
            this.getOuter().removeKey(item);
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public void clear() {
        this.getOuter().clear();
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept((byte)0)) {
                return 0;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept((byte)1)) {
                return 1;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return this.getKeyAtIndex(i);
        }
        return ifNone;
    }

    @Override
    public MutableByteSet asUnmodifiable() {
        return UnmodifiableByteSet.of(this);
    }

    @Override
    public MutableByteSet asSynchronized() {
        return SynchronizedByteSet.of(this);
    }

    @Override
    public long sum() {
        long result = 0L;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0L;
            }
            if (this.getSentinelValues().containsOneKey) {
                ++result;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += (long)this.getKeyAtIndex(i);
        }
        return result;
    }

    @Override
    public byte max() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        byte max = 0;
        boolean isMaxSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                max = 0;
                isMaxSet = true;
            }
            if (this.getSentinelValues().containsOneKey) {
                max = 1;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMaxSet && max >= this.getKeyAtIndex(i)) continue;
            max = this.getKeyAtIndex(i);
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public byte min() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        byte min = 0;
        boolean isMinSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                min = 0;
                isMinSet = true;
            }
            if (this.getSentinelValues().containsOneKey && !isMinSet) {
                min = 1;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMinSet && this.getKeyAtIndex(i) >= min) continue;
            min = this.getKeyAtIndex(i);
            isMinSet = true;
        }
        return min;
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableByteList toSortedList() {
        return ByteArrayList.newList(this).sortThis();
    }

    @Override
    public byte[] toArray() {
        int size = this.getOuter().size();
        final byte[] result = new byte[size];
        this.getOuter().forEachKey(new ByteProcedure(){
            private int index;

            @Override
            public void value(byte each) {
                result[this.index] = each;
                ++this.index;
            }
        });
        return result;
    }

    @Override
    public byte[] toArray(byte[] result) {
        int size = this.getOuter().size();
        if (result.length < size) {
            result = new byte[size];
        }
        final byte[] finalBypass = result;
        this.getOuter().forEachKey(new ByteProcedure(){
            private int index;

            @Override
            public void value(byte each) {
                finalBypass[this.index] = each;
                ++this.index;
            }
        });
        return result;
    }

    @Override
    public boolean contains(byte value) {
        return this.getOuter().containsKey(value);
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte item : source) {
            if (this.getOuter().containsKey(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.getOuter().containsKey(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public LazyIterable<ByteBytePair> cartesianProduct(ByteSet set) {
        return ByteSets.cartesianProduct(this, set);
    }

    @Override
    public MutableByteList toList() {
        return ByteArrayList.newList(this);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteHashSet.newSet(this);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteHashBag.newBag(this);
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result = function.valueOf(result, (byte)0);
            }
            if (this.getSentinelValues().containsOneKey) {
                result = function.valueOf(result, (byte)1);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result = function.valueOf(result, this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public ImmutableByteSet toImmutable() {
        return ByteSets.immutable.withAll(this);
    }

    @Override
    public int size() {
        return this.getOuter().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getOuter().isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.getOuter().notEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteSet)) {
            return false;
        }
        ByteSet other = (ByteSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0;
            }
            if (this.getSentinelValues().containsOneKey) {
                ++result;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += this.getKeyAtIndex(i);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(0));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!AbstractMutableByteKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getKeyAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList<ByteIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(ByteSets.mutable.withAll(this));
            } else {
                MutableByteIterator iterator = this.byteIterator();
                while (iterator.hasNext()) {
                    MutableByteSet batch = ByteSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch);
                }
            }
        }
        return result;
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerRep(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    private static class SerRep
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private transient AbstractMutableByteKeySet original;
        private transient ByteHashSet deserialized;

        public SerRep() {
        }

        private SerRep(AbstractMutableByteKeySet original) {
            this.original = original;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.original.size());
            MutableByteIterator it = this.original.byteIterator();
            while (it.hasNext()) {
                out.writeByte(it.next());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int unread;
            this.deserialized = new ByteHashSet(unread);
            for (unread = in.readInt(); unread > 0; --unread) {
                this.deserialized.add(in.readByte());
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.deserialized;
        }
    }
}

