/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.multimap;

import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.util.Collection;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function0;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.ImmutableCollection;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Maps;
import shadow.palantir.driver.org.eclipse.collections.api.map.ImmutableMap;
import shadow.palantir.driver.org.eclipse.collections.api.map.MutableMap;
import shadow.palantir.driver.org.eclipse.collections.api.multimap.ImmutableMultimap;
import shadow.palantir.driver.org.eclipse.collections.api.set.SetIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.multimap.AbstractMultimap;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.Iterate;

public abstract class AbstractImmutableMultimap<K, V, C extends ImmutableCollection<V>>
extends AbstractMultimap<K, V, C>
implements ImmutableMultimap<K, V> {
    protected final ImmutableMap<K, C> map;

    protected AbstractImmutableMultimap(MutableMap<K, C> map) {
        this((ImmutableMap<K, C>)map.toImmutable());
    }

    protected AbstractImmutableMultimap(ImmutableMap<K, C> immutableMap) {
        this.map = immutableMap;
    }

    @Override
    protected ImmutableMap<K, C> getMap() {
        return this.map;
    }

    @Override
    public int size() {
        class CountProcedure
        implements Procedure<C> {
            private static final long serialVersionUID = 1L;
            private int totalSize;

            CountProcedure() {
            }

            @Override
            public void value(C collection) {
                this.totalSize += collection.size();
            }

            public int getTotalSize() {
                return this.totalSize;
            }
        }
        CountProcedure procedure = new CountProcedure();
        this.map.forEachValue(procedure);
        return procedure.getTotalSize();
    }

    @Override
    public int sizeDistinct() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public SetIterable<K> keySet() {
        return UnmodifiableMutableSet.of(this.getMap().castToMap().keySet());
    }

    public C get(K key) {
        return (C)((ImmutableCollection)this.map.getIfAbsentWith(key, this.createCollectionBlock(), this));
    }

    @Override
    public MutableMap<K, RichIterable<V>> toMap() {
        return this.map.toMap();
    }

    @Override
    public <R extends Collection<V>> MutableMap<K, R> toMap(Function0<R> collectionFactory) {
        MutableMap result = Maps.mutable.empty();
        this.map.forEachKeyValue((key, iterable) -> {
            Collection newCollection = (Collection)collectionFactory.value();
            Iterate.addAllTo(iterable, newCollection);
            result.put(key, newCollection);
        });
        return result;
    }

    @Override
    public ImmutableMultimap<K, V> toImmutable() {
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        throw new InvalidClassException("You should be using the proxy for serialization of ImmutableMultimaps");
    }
}

