/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.multimap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.map.ImmutableMap;
import shadow.palantir.driver.org.eclipse.collections.api.multimap.Multimap;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.checked.MultimapKeyValuesSerializingProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.multimap.AbstractMutableMultimap;

public abstract class ImmutableMultimapSerializationProxy<K, V, R extends RichIterable<V>> {
    private Multimap<K, V> multimapToReadInto;
    private ImmutableMap<K, R> mapToWrite;

    protected ImmutableMultimapSerializationProxy() {
    }

    protected ImmutableMultimapSerializationProxy(ImmutableMap<K, R> immutableMap) {
        this.mapToWrite = immutableMap;
    }

    protected abstract AbstractMutableMultimap<K, V, ?> createEmptyMutableMultimap();

    protected Object readResolve() {
        return this.multimapToReadInto.toImmutable();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int keysCount = this.mapToWrite.size();
        out.writeInt(keysCount);
        this.mapToWrite.forEachKeyValue(new MultimapKeyValuesSerializingProcedure(out));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        AbstractMutableMultimap<K, V, ?> toReadInto = this.createEmptyMutableMultimap();
        toReadInto.readValuesFrom(in);
        this.multimapToReadInto = toReadInto;
    }
}

