/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.parallel;

import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.impl.parallel.ArrayProcedureFJTaskRunner;
import shadow.palantir.driver.org.eclipse.collections.impl.parallel.ProcedureFactory;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.ArrayIterate;

public final class ArrayProcedureFJTask<T, BT extends Procedure<? super T>>
implements Runnable {
    private final ProcedureFactory<BT> procedureFactory;
    private BT procedure;
    private final T[] array;
    private final int start;
    private final int end;
    private final ArrayProcedureFJTaskRunner<T, BT> taskRunner;

    public ArrayProcedureFJTask(ArrayProcedureFJTaskRunner<T, BT> newFJTaskRunner, ProcedureFactory<BT> procedureFactory, T[] newArray, int newIndex, int newSectionSize, boolean isLast) {
        this.taskRunner = newFJTaskRunner;
        this.procedureFactory = procedureFactory;
        this.array = newArray;
        this.start = newIndex * newSectionSize;
        this.end = isLast ? this.array.length : this.start + newSectionSize;
    }

    @Override
    public void run() {
        try {
            this.procedure = this.procedureFactory.create();
            ArrayIterate.forEach(this.array, this.start, this.end - 1, this.procedure);
        }
        catch (Throwable newError) {
            this.taskRunner.setFailed(newError);
        }
        finally {
            this.taskRunner.taskCompleted(this);
        }
    }

    public BT getProcedure() {
        return this.procedure;
    }
}

