/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.parallel;

import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.list.ListIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.parallel.ProcedureFJTaskRunner;
import shadow.palantir.driver.org.eclipse.collections.impl.parallel.ProcedureFactory;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.ArrayListIterate;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.ListIterate;

public final class ProcedureFJTask<T, BT extends Procedure<? super T>>
implements Runnable {
    private final ProcedureFactory<BT> procedureFactory;
    private BT procedure;
    private final List<T> list;
    private final int start;
    private final int end;
    private final ProcedureFJTaskRunner<T, BT> taskRunner;

    public ProcedureFJTask(ProcedureFJTaskRunner<T, BT> newFJTaskRunner, ProcedureFactory<BT> newProcedureFactory, List<T> list, int index, int sectionSize, boolean isLast) {
        this.taskRunner = newFJTaskRunner;
        this.procedureFactory = newProcedureFactory;
        this.list = list;
        this.start = index * sectionSize;
        this.end = isLast ? this.list.size() : this.start + sectionSize;
    }

    @Override
    public void run() {
        try {
            this.procedure = this.procedureFactory.create();
            int stop = this.end - 1;
            if (this.list instanceof ListIterable) {
                ((ListIterable)((Object)this.list)).forEach(this.start, stop, this.procedure);
            } else if (this.list instanceof ArrayList) {
                ArrayListIterate.forEach((ArrayList)this.list, this.start, stop, this.procedure);
            } else {
                ListIterate.forEach(this.list, this.start, stop, this.procedure);
            }
        }
        catch (Throwable newError) {
            this.taskRunner.setFailed(newError);
        }
        finally {
            this.taskRunner.taskCompleted(this);
        }
    }

    public BT getProcedure() {
        return this.procedure;
    }
}

