/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.primitive;

import java.util.Arrays;
import shadow.palantir.driver.org.eclipse.collections.api.FloatIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyFloatIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.FloatBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.FloatLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.FloatSets;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableFloatList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableFloatSet;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;

public abstract class AbstractFloatIterable
implements FloatIterable {
    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        float[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            float first = sortedArray[middleIndex];
            float second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableFloatList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public MutableFloatList toList() {
        return FloatLists.mutable.withAll(this);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatSets.mutable.withAll(this);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatBags.mutable.withAll(this);
    }
}

