/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.primitive;

import java.util.Arrays;
import shadow.palantir.driver.org.eclipse.collections.api.LazyShortIterable;
import shadow.palantir.driver.org.eclipse.collections.api.ShortIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableShortBag;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortLists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortSets;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableShortList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableShortSet;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;

public abstract class AbstractShortIterable
implements ShortIterable {
    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableShortList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public MutableShortList toList() {
        return ShortLists.mutable.withAll(this);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortSets.mutable.withAll(this);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortBags.mutable.withAll(this);
    }
}

